//
// Cforall Version 1.0.0 Copyright (C) 2015 University of Waterloo
//
// The contents of this file are covered under the licence agreement in the
// file "LICENCE" distributed with Cforall.
//
// SynTree.h --
//
// Author           : Richard C. Bilson
// Created On       : Mon May 18 07:44:20 2015
// Last Modified By : Peter A. Buhr
// Last Modified On : Wed Aug  3 17:02:34 2016
// Update Count     : 7
//

#ifndef SYNTREE_H
#define SYNTREE_H

#include <string>
#include <list>
#include <map>
#include <iostream>

class Declaration;
class DeclarationWithType;
class ObjectDecl;
class FunctionDecl;
class AggregateDecl;
class StructDecl;
class UnionDecl;
class EnumDecl;
class TraitDecl;
class NamedTypeDecl;
class TypeDecl;
class FtypeDecl;
class DtypeDecl;
class TypedefDecl;

class Statement;
class CompoundStmt;
class ExprStmt;
class AsmStmt;
class IfStmt;
class WhileStmt;
class ForStmt;
class SwitchStmt;
class CaseStmt;
class BranchStmt;
class ReturnStmt;
class TryStmt;
class CatchStmt;
class FinallyStmt;
class NullStmt;
class DeclStmt;
class NullStmt;
class ImplicitCtorDtorStmt;

class Expression;
class ApplicationExpr;
class UntypedExpr;
class NameExpr;
class AddressExpr;
class LabelAddressExpr;
class CastExpr;
class MemberExpr;
class UntypedMemberExpr;
class VariableExpr;
class ConstantExpr;
class SizeofExpr;
class AlignofExpr;
class UntypedOffsetofExpr;
class OffsetofExpr;
class OffsetPackExpr;
class AttrExpr;
class LogicalExpr;
class ConditionalExpr;
class CommaExpr;
class TupleExpr;
class SolvedTupleExpr;
class TypeExpr;
class AsmExpr;
class ImplicitCopyCtorExpr;
class UntypedValofExpr;
class CompoundLiteralExpr;
class RangeExpr;

class Type;
class VoidType;
class BasicType;
class PointerType;
class ArrayType;
class FunctionType;
class ReferenceToType;
class StructInstType;
class UnionInstType;
class EnumInstType;
class TraitInstType;
class TypeInstType;
class TupleType;
class TypeofType;
class AttrType;
class VarArgsType;

class Initializer;
class SingleInit;
class ListInit;
class ConstructorInit;

class Subrange;

//template <class T>	// emulate a union with templates?
class Constant;

// typedef std::string Label;
class Label;
typedef unsigned int UniqueId;

class TypeSubstitution;

// gcc attribute
class Attribute;

#endif // SYNTREE_H

// Local Variables: //
// tab-width: 4 //
// mode: c++ //
// compile-command: "make install" //
// End: //
