//
// Cforall Version 1.0.0 Copyright (C) 2015 University of Waterloo
//
// The contents of this file are covered under the licence agreement in the
// file "LICENCE" distributed with Cforall.
//
// RemoveInit.h --
//
// Author           : Rob Schluntz
// Created On       : Fri May 13 11:26:36 2016
// Last Modified By : Rob Schluntz
// Last Modified On : Fri May 13 11:35:36 2016
// Update Count     : 3
//

#ifndef INIT_TWEAK_H
#define INIT_TWEAK_H

#include <string>
#include <list>

#include "SynTree/SynTree.h"
#include "SynTree/Declaration.h"
#include "SynTree/Mutator.h"

// helper functions for initialization
namespace InitTweak {
  /// transform Initializer into an argument list that can be passed to a call expression
  std::list< Expression * > makeInitList( Initializer * init );

  /// True if the resolver should try to construct objDecl
  bool tryConstruct( ObjectDecl * objDecl );

  /// True if the Initializer contains designations
  bool isDesignated( Initializer * init );

  /// True if stmt is a call statement where the function called is intrinsic and takes one parameter.
  /// Intended to be used for default ctor/dtor calls, but might have use elsewhere.
  /// Currently has assertions that make it less than fully general.
  bool isInstrinsicSingleArgCallStmt( Statement * expr );

  /// get the Ctor/Dtor call expression from a Statement that looks like a generated ctor/dtor call
  Expression * getCtorDtorCall( Statement * stmt );

  /// returns the name of the function being called
  std::string getFunctionName( Expression * expr );

  /// returns the argument to a call expression in position N indexed from 0
  Expression *& getCallArg( Expression * callExpr, unsigned int pos );

  /// returns the base type of a PointerType or ArrayType, else returns NULL
  Type * getPointerBase( Type * );

  /// returns the argument if it is a PointerType or ArrayType, else returns NULL
  Type * isPointerType( Type * );
} // namespace

#endif // INITTWEAK_GENINIT_H

// Local Variables: //
// tab-width: 4 //
// mode: c++ //
// compile-command: "make install" //
// End: //
