//
// Cforall Version 1.0.0 Copyright (C) 2015 University of Waterloo
//
// The contents of this file are covered under the licence agreement in the
// file "LICENCE" distributed with Cforall.
//
// iterator.c -- 
//
// Author           : Richard C. Bilson
// Created On       : Wed May 27 17:56:53 2015
// Last Modified By : Peter A. Buhr
// Last Modified On : Wed Mar  2 18:08:11 2016
// Update Count     : 27
//

#include "iterator"

forall( otype iterator_type, otype elt_type | iterator( iterator_type, elt_type ) )
void for_each( iterator_type begin, iterator_type end, void (*func)( elt_type ) ) {
	for ( iterator_type i = begin; i != end; ++i ) {
		func( *i );
	}
}

forall( otype iterator_type, otype elt_type | iterator( iterator_type, elt_type ) )
void for_each_reverse( iterator_type begin, iterator_type end, void (*func)( elt_type ) ) {
	for ( iterator_type i = end; i != begin; ) {
		--i;
		func( *i );
	}
}

// Local Variables: //
// tab-width: 4 //
// compile-command: "cfa iterator.c" //
// End: //
