#include "vector.h"

//------------------------------------------------------------------------------
//Initialization
forall(otype T, otype allocator_t | allocator_c(T, allocator_t))
void vector_ctor(vector(T, allocator_t) *const this)
{
	ctor(&this->storage);
	this->size = 0;
}

forall(otype T, otype allocator_t | allocator_c(T, allocator_t))
void dtor(vector(T, allocator_t) *const this)
{
	dtor(&this->storage);
}

//------------------------------------------------------------------------------
//Modifiers
forall(otype T, otype allocator_t | allocator_c(T, allocator_t))
void push_back(vector(T, allocator_t) *const this, T value)
{
	realloc(&this->storage, this->size+1);
	data(&this->storage)[this->size] = value;
	this->size++;
}

forall(otype T, otype allocator_t | allocator_c(T, allocator_t))
void pop_back(vector(T, allocator_t) *const this)
{
	this->size--;
	DESTROY(data(&this->storage)[this->size]);
}

forall(otype T, otype allocator_t | allocator_c(T, allocator_t))
void clear(vector(T, allocator_t) *const this)
{
	for(size_t i = 0; i < this->size; i++)
	{
		DESTROY(data(&this->storage)[this->size]);
	}
	this->size = 0;
}

//------------------------------------------------------------------------------
//Allocator
forall(otype T)
void ctor(heap_allocator(T) *const this)
{
	this->storage = 0;
	this->capacity = 0;
}

forall(otype T)
void dtor(heap_allocator(T) *const this)
{
	free((void*)this->storage);
}

forall(otype T)
inline void realloc(heap_allocator(T) *const this, size_t size)
{
	static const size_t GROWTH_RATE = 2;
	if(size > this->capacity)
	{
		this->capacity = GROWTH_RATE * size;
		this->storage = (T*)realloc((void*)this->storage, this->capacity * sizeof(T));
	}
}
