#include "state.h"

#include <stdlib.h>

//general purpouse includes
#include "tools.h"

//platform abstraction includes
#include "allocate-pool.h"

//gc internal includes
#include "globals.h"
#include "memory_pool.h"
// #include "memory_pool_iterator.h"
#include "object_header.h"

void gc_state_swap(gc_state *const this);
void gc_state_sweep_roots(gc_state *const this, worklist_t* worklist);
void gc_state_clear(gc_state *const this);
void gc_state_calc_usage(gc_state *const this);

#if DEBUG
	bool gc_state_roots_match(gc_state *const this);
	bool gc_state_no_from_space_ref(gc_state *const this);
#endif

gc_state* gc_get_state()
{
	static gc_state s;
	if(!s.is_initialized) gc_state_ctor(&s);
	return &s;
}

void gc_state_ctor(gc_state *const this)
{
	this->from_code = 0;
	this->to_space = NULL;
	this->from_space = NULL;
	this->total_space = 0;
	this->used_space = 0;
	// state->pools_table();

	gc_allocate_pool(this);

	this->is_initialized = true;
}

// bool state::is_in_heap(void* address) const
// {
// 	memory_pool* target_pool = gc_pool_of(address);
//
// 	auto first = pools_table.cbegin();
// 	auto last = pools_table.cend();
// 	auto result = std::find(first, last, target_pool);
// 	return result != last && (*result)->is_from_space();
// }

// bool state::is_in_to_space(void* address) const
// {
// 	const memory_pool* target_pool = pool_of(address);
//
// 	auto first = pools_table.cbegin();
// 	auto last = pools_table.cend();
// 	auto result = std::find(first, last, target_pool);
// 	return result != last && !(*result)->is_from_space();
// }
//
// gc_object_header* gc_get_object_for_ref(gc_state* state, void* member)
// {
// 	intptr_t target = ((intptr_t)member);
// 	if(!gc_is_in_heap(state, member)) return NULL;
//
// 	gc_memory_pool* pool = gc_pool_of(member);
// 	gc_pool_object_iterator it = gc_pool_iterator_for(pool, member);
// 	gc_pool_object_iterator end = gc_pool_end(pool);
//
// 	while(it != end)
// 	{
// 		gc_object_header* object = *it;
// 		{
// 			intptr_t start = ((intptr_t)object);
// 			intptr_t end = ((intptr_t)start + object->size);
// 			if(start < target && end > target)
// 			{
// 				return object;
// 			}
// 		}
// 		++it;
// 	}
//
// 	checkf(false, "is_in_heap() and iterator_for() return inconsistent data");
// 	abort();
// 	return NULL;
// }

void* gc_state_try_allocate(gc_state *const this, size_t size)
{
	gc_memory_pool* pool = this->from_space;
	while(pool != (gc_memory_pool*)0)
	{
		if(gc_pool_size_left(pool) > size)
		{
			return gc_pool_allocate(pool, size, true);
		}
		pool = pool->next;
	}

	return (void*)0;
}

void gc_state_allocate_pool(gc_state *const this)
{
	gc_memory_pool* old_from_space = this->from_space;
      gc_memory_pool* old_to_space = this->to_space;

      this->from_space = (gc_memory_pool*)(pal_allocPool(POOL_SIZE_BYTES, 1));
      this->to_space = (gc_memory_pool*)(pal_allocPool(POOL_SIZE_BYTES, 1));

      gc_memory_pool_ctor(this->from_space, POOL_SIZE_BYTES, old_from_space, this->to_space,   this->from_code);
      gc_memory_pool_ctor(this->to_space,   POOL_SIZE_BYTES, old_to_space,   this->from_space, (~this->from_code) & 0x01);

	this->total_space += gc_pool_size_used(this->from_space);

	// pools_table.push_back(from_space);
	// pools_table.push_back(to_space);
}

void gc_state_collect(gc_state *const this)
{
	// DEBUG("collecting");
	// DEBUG("previous usage " << this->used_space << " / " << this->total_space);

	worklist_t worklist;
	// vector_ctor(&worklist);
	gc_state_sweep_roots(this, &worklist);

	while(!empty(&worklist))
	{
		void** ref = back(&worklist);
		pop_back(&worklist);
		gc_state_process_reference(this, ref, &worklist);
	}
	//
	// check(gc_state_roots_match(this));
	// check(gc_state_no_from_space_ref(this));
	//
	// gc_state_swap(this);
	//
	// gc_state_calc_usage(this);
	//
	// if(gc_state_needs_collect(this)) gc_state_allocate_pool(this);

	// DEBUG("done");
	// dtor(&worklist);
}
//
// void state::swap()
// {
// 	std::swap(from_space, to_space);
//
// 	memory_pool* pool = to_space;
// 	while(pool)
// 	{
// 		pool->reset();
// 		pool = pool->next();
// 	}
//
// 	from_code = (~from_code) & 0x01;
//
// 	#if _DEBUG
// 		{
// 			memory_pool* pool = from_space;
// 			while(pool)
// 			{
// 				check(pool->is_from_space());
// 				pool = pool->next();
// 			}
//
// 			pool = to_space;
// 			while(pool)
// 			{
// 				check(!pool->is_from_space());
// 				pool = pool->next();
// 			}
// 		}
// 	#endif
// }
//
// void state::sweep_roots(std::vector<void**>& worklist)
// {
// 	memory_pool* pool = from_space;
// 	while(pool)
// 	{
// 		for(object_header* object : *pool)
// 		{
// 			if(!object->root_chain) continue;
//
// 			copy_object(object);
//
// 			scan_object(object->forward, worklist);
// 		}
//
// 		pool = pool->next();
// 	}
// }
//
// void state::clear()
// {
// 	memory_pool* pool = from_space;
// 	while(pool)
// 	{
// 		pool->reset();
// 		pool = pool->next();
// 	}
//
// 	pool = to_space;
// 	while(pool)
// 	{
// 		pool->reset();
// 		pool = pool->next();
// 	}
// }
//
// void state::calc_usage()
// {
// 	total_space = 0;
// 	used_space = 0;
//
// 	memory_pool* pool = from_space;
// 	while(pool)
// 	{
// 		size_t size = pool->size();
// 		size_t used = size - pool->size_left();
// 		check(used <= size);
// 		total_space += size;
// 		used_space += used;
//
// 		pool = pool->next();
// 	}
// }
//
// #if _DEBUG
// 	bool state::roots_match()
// 	{
// 		memory_pool* pool = to_space;
// 		while(pool)
// 		{
// 			size_t size = 0;
// 			for(object_header* object : *pool)
// 			{
// 				size += object->size;
//
// 				gcpointer_base* ptr = object->root_chain;
// 				while(ptr)
// 				{
// 					check(get_object_ptr(ptr->m_ptr) == object);
// 					ptr = ptr->m_next;
// 				}
// 			}
//
// 			check(size + pool->size_left() == pool->size());
//
// 			pool = pool->next();
// 		}
//
// 		return true;
// 	}
//
// 	bool state::no_from_space_ref()
// 	{
// 		memory_pool* pool = to_space;
// 		while(pool)
// 		{
// 			void** potential_ref = (void**)pool->m_start;
// 			while(potential_ref < (void**)pool->m_free)
// 			{
// 				check(!is_in_heap(*potential_ref));
// 				potential_ref++;
// 			}
//
// 			pool = pool->next();
// 		}
//
// 		return true;
// 	}
// #endif
