#pragma once

#include <stddef.h>
#include <stdint.h>

#include "tools.h"
//
#include "gcpointers.h"
#include "state.h"
#include "internal/gc_tools.h"
#include "internal/globals.h"
#include "internal/object_header.h"
#include "internal/state.h"
#include "tools/worklist.h"

inline bool gc_is_managed(void* address)
{
	return gc_is_in_heap(gc_get_state(), address);
}

inline gc_object_header* gc_get_object_ptr(void* ptr)
{
	void* clean = gc_get_aligned_ptr(ptr);
	return ((gc_object_header*)clean) - 1;
}

inline struct gc_memory_pool* gc_pool_of(void* address)
{
	return (struct gc_memory_pool*)(((intptr_t)address) & POOL_PTR_MASK);
}

inline void gc_conditional_collect()
{
	if(gc_needs_collect(gc_get_state()))
	{
		gc_collect(gc_get_state());
	}
}

gcpointer_t** gc_find_previous_ref(gcpointer_t* target);

void* gc_allocate(size_t size);

void gc_process_reference(void** ref, worklist_t* worklist);

struct gc_object_header* gc_copy_object(struct gc_object_header* ptr);

void gc_scan_object(struct gc_object_header* object, worklist_t* worklist);
