#include <stddef.h>
#include <stdint.h>

//------------------------------------------------------------------------------
//Declaration
trait allocator_c(otype T, otype allocator_t) {
	void realloc(allocator_t*, size_t);
	T* data(allocator_t*);
};

forall(otype T, otype allocator_t | allocator_c(T, allocator_t))
struct vector
{
	allocator_t storage;
	size_t size;
};

//------------------------------------------------------------------------------
//Allocator
forall(otype T)
struct heap_allocator
{
	T* storage;
	size_t capacity;
};

forall(otype T)
void realloc(heap_allocator(T)* this, size_t size);

forall(otype T)
inline T* data(heap_allocator(T)* this)
{
	return this->storage;
}

//------------------------------------------------------------------------------
//Modifiers
forall(otype T, otype allocator_t | allocator_c(T, allocator_t))
void push_back(vector(T, allocator_t)* this, T value);

typedef vector(intptr_t*, heap_allocator(intptr_t*)) worklist_t;

inline void test()
{
	worklist_t w;
	intptr_t zero = 0;
	push_back(&w, &zero);
}
