/*
 * This file is part of the Cforall project
 *
 * $Id: Initializer.cc,v 1.10 2005/08/29 20:59:25 rcbilson Exp $
 *
 */

#include "Initializer.h"
#include "Expression.h"
#include "utility.h"


Initializer::Initializer( )
{
}

Initializer::~Initializer( )
{
}

std::string Initializer::designator_name( Expression *des ) {
    if( NameExpr *n = dynamic_cast<NameExpr *>(des) )
	return n->get_name();
    else
	throw 0;
}

void 
Initializer::print( std::ostream &os, int indent )
{
}

SingleInit::SingleInit( Expression *v, std::list< Expression *> &_designators )
    : value ( v ), designators( _designators )
{ 
}

SingleInit::SingleInit ( const SingleInit &other )
    : value ( other.value )
{
    cloneAll(other.designators, designators );
}

SingleInit::~SingleInit()
{
}

SingleInit *SingleInit::clone() const { return new SingleInit( *this); }

void SingleInit::print( std::ostream &os, int indent )
{
    os << std::endl << std::string(indent, ' ' ) << "Simple Initializer: ";
    value->print( os, indent+2 );

    if ( ! designators.empty() )
	{
	    os << std::endl << std::string(indent + 2, ' ' ) << "designated by: "  ;
	    for ( std::list < Expression * >::iterator i = designators.begin(); i != designators.end(); i++ )
		( *i )->print(os, indent + 4 );
	}
}

MemberInit::MemberInit( Expression *_value, std::string _member )
    : member ( _member ), value ( _value )
{
}

MemberInit::~MemberInit()
{
}

MemberInit * MemberInit::clone() const
{
    return new MemberInit( *this );
}

void MemberInit::print( std::ostream &os, int indent )
{
    os << "Member Initializer";
    value->print( os, indent+2 );
}

ListInit::ListInit( std::list<Initializer*> &_initializers, std::list<Expression *> &_designators )
    : initializers( _initializers ), designators( _designators )
{
}

ListInit::~ListInit()
{
}

ListInit *ListInit::clone() const
{
    return new ListInit( *this );
}

void ListInit::print( std::ostream &os, int indent )
{
    os << std::endl << std::string(indent, ' ') << "Compound initializer:  "; 
    if( ! designators.empty() ) {
	os << std::string(indent + 2, ' ' ) << "designated by: [";
	for ( std::list < Expression * >::iterator i = designators.begin();
		    i != designators.end(); i++ ) {
	    ( *i )->print(os, indent + 4 ); 
	}
	
	os << std::string(indent + 2, ' ' ) << "]";
    }

    for( std::list<Initializer *>::iterator i = initializers.begin(); i != initializers.end(); i++ ) 
	(*i)->print( os, indent + 2 );
}
