#ifndef LINKAGESPEC_H
#define LINKAGESPEC_H

#include <string>

struct LinkageSpec {
    enum Type {
	Intrinsic,		// C built-in defined in prelude
	Cforall,		// ordinary
	C,			// not overloadable, not mangled
	AutoGen,		// built by translator (struct assignment)
	Compiler		// gcc internal
    };
  
    static Type fromString( const std::string & );
    static std::string toString( Type );
  
    static bool isDecoratable( Type );
    static bool isGeneratable( Type );
    static bool isOverloadable( Type );
    static bool isBuiltin( Type );
};

#endif // LINKAGESPEC_H
