#include <string>
#include <cassert>

#include "LinkageSpec.h"
#include "SemanticError.h"

LinkageSpec::Type LinkageSpec::fromString( const std::string &stringSpec ) {
    if ( stringSpec == "\"Cforall\"" ) {
	return Cforall;
    } else if ( stringSpec == "\"C\"" ) {
	return C;
    } else {
	throw SemanticError( "Invalid linkage specifier " + stringSpec );
    }
}

std::string LinkageSpec::toString( LinkageSpec::Type linkage ) {
    switch ( linkage ) {
      case Intrinsic:
	return "intrinsic";
      case Cforall:
	return "Cforall";
      case C:
	return "C";
      case AutoGen:
	return "automatically generated";
      case Compiler:
	return "compiler built-in";
    }
    assert( false );
    return "";
}

bool LinkageSpec::isDecoratable( Type t ) {
    switch ( t ) {
      case Intrinsic:
      case Cforall:
      case AutoGen:
	return true;
      case C:
      case Compiler:
	return false;
    }
    assert( false );
    return false;
}

bool LinkageSpec::isGeneratable( Type t ) {
    switch ( t ) {
      case Intrinsic:
      case Cforall:
      case AutoGen:
      case C:
	return true;
      case Compiler:
	return false;
    }
    assert( false );
    return false;
}

bool LinkageSpec::isOverloadable( Type t ) {
    return isDecoratable( t );
}

bool LinkageSpec::isBuiltin( Type t ) {
    switch ( t ) {
      case Cforall:
      case AutoGen:
      case C:
	return false;
      case Intrinsic:
      case Compiler:
	return true;
    }
    assert( false );
    return false;
}
