//
// Cforall Version 1.0.0 Copyright (C) 2015 University of Waterloo
//
// The contents of this file are covered under the licence agreement in the
// file "LICENCE" distributed with Cforall.
//
// DeclarationWithType.cc --
//
// Author           : Richard C. Bilson
// Created On       : Mon May 18 07:44:20 2015
// Last Modified By : Peter A. Buhr
// Last Modified On : Tue Dec 13 14:49:43 2016
// Update Count     : 7
//

#include "Declaration.h"
#include "Type.h"
#include "Attribute.h"
#include "Common/utility.h"

DeclarationWithType::DeclarationWithType( const std::string &name, DeclarationNode::StorageClass sc, LinkageSpec::Spec linkage, const std::list< Attribute * > & attributes )
	: Declaration( name, sc, linkage ), asmName( nullptr ), attributes( attributes ) {
}

DeclarationWithType::DeclarationWithType( const DeclarationWithType &other )
		: Declaration( other ), mangleName( other.mangleName ), scopeLevel( other.scopeLevel ) {
	cloneAll( other.attributes, attributes );
	asmName = maybeClone( other.asmName );
}

DeclarationWithType::~DeclarationWithType() {
	deleteAll( attributes );
	delete asmName;
}

// Local Variables: //
// tab-width: 4 //
// mode: c++ //
// compile-command: "make install" //
// End: //
