#!/bin/bash

GitOldRef=$1
GitNewRef=$2

revisions=$(git rev-list ${GitOldRef}..${GitNewRef})

rm -f GIT_UPDATE GIT_LOG GIT_DIFF

for rev in ${revisions}; do
    type=$(git cat-file -t ${rev})
    echo "       via  ${rev} (${type})" >> GIT_UPDATE
done
rev=${GitOldRef}
type=$(git cat-file -t ${rev})
echo "      from  ${rev} (${type})" >> GIT_UPDATE

git rev-list --format=short ${GitOldRef}...${GitNewRef} > GIT_LOG

git diff --stat ${GitNewRef} ${GitOldRef} > GIT_DIFF