//
// Cforall Version 1.0.0 Copyright (C) 2015 University of Waterloo
//
// The contents of this file are covered under the licence agreement in the
// file "LICENCE" distributed with Cforall.
//
// Decl.cpp --
//
// Author           : Aaron B. Moss
// Created On       : Thu May 9 10:00:00 2019
// Last Modified By : Aaron B. Moss
// Last Modified On : Thu May 9 10:00:00 2019
// Update Count     : 1
//

#include <cassert>        // for assert, strict_dynamic_cast
#include <unordered_map>

#include "Decl.hpp"

#include "Fwd.hpp"        // for UniqueId
#include "Init.hpp"
#include "Node.hpp"       // for readonly

namespace ast {

// To canonicalize declarations
static UniqueId lastUniqueId = 0;

using IdMapType = std::unordered_map< UniqueId, readonly<Decl> >;
static IdMapType idMap;

void Decl::fixUniqueId() {
	if ( uniqueId ) return;  // ensure only set once
	uniqueId = ++lastUniqueId;
	idMap[ uniqueId ] = this;
}

readonly<Decl> Decl::fromId( UniqueId id ) {
	IdMapType::const_iterator i = idMap.find( id );
	if ( i != idMap.end() ) return i->second;
	return {};
}

// --- EnumDecl

bool EnumDecl::valueOf( Decl* enumerator, long long& value ) const {
	if ( enumValues.empty() ) {
		long long crntVal = 0;
		for ( const Decl* member : members ) {
			const ObjectDecl* field = strict_dynamic_cast< const ObjectDecl* >( member );
			if ( field->init ) {
				const SingleInit* init = strict_dynamic_cast< const SingleInit* >( field->init );
				auto result = eval( init->value );
				if ( ! result.second ) {
					SemanticError( init->location, toString( "Non-constexpr in initialization of "
						"enumerator: ", field ) );
				}
				crntVal = result.first;
			}
			if ( enumValues.count( field->name ) != 0 ) {
				SemanticError( location, toString( "Enum ", name, " has multiple members with the " 	"name ", field->name ) );
			}
			enumValues[ field->name ] = crntVal;
			++crntVal;
		}
	}

	auto it = enumValues.find( enumerator->name );
	if ( it != enumValues.end() ) {
		value = it->second;
		return true;
	}
	return false;
}

}

// Local Variables: //
// tab-width: 4 //
// mode: c++ //
// compile-command: "make install" //
// End: //
