//
// Cforall Version 1.0.0 Copyright (C) 2015 University of Waterloo
//
// The contents of this file are covered under the licence agreement in the
// file "LICENCE" distributed with Cforall.
//
// GcTracer.h --
//
// Author           : Aaron B. Moss
// Created On       : Thu Mar 15 14:47:00 2018
// Last Modified By : Aaron B. Moss
// Last Modified On : Thu Mar 15 14:47:00 2018
// Update Count     : 1
//

#pragma once

#include <list>

#include "BaseSyntaxNode.h"
#include "Expression.h"
#include "Type.h"

#include "Common/GC.h"
#include "Common/PassVisitor.h"

class Expression;

/// Implements `trace` method for syntax nodes
class GcTracer final : public WithShortCircuiting, public WithVisitorRef<GcTracer> {
	const GC& gc;

public:
	GcTracer( const GC& gc ) : gc(gc) {}

	// mark node and children

	void previsit( BaseSyntaxNode * node ) {
		// skip tree if already seen
		// if ( node->mark == gc.mark ) {
		// 	visit_children = false;
		// 	return;
		// }

		// mark node
		node->mark = gc.mark;
	}

	// add visits left out by PassVisitor

	void postvisit( Expression* expr ) {
		maybeAccept( expr->env, *visitor );
	}

	void postvisit( UntypedExpr* expr ) {
		postvisit( static_cast<Expression*>(expr) );
		maybeAccept( expr->function, *visitor );
	}

	void postvisit( PointerType* pty ) {
		maybeAccept( pty->dimension, *visitor );
	}
};

/// Traces entire translation unit recursively
static inline const GC& operator<< ( const GC& gc, const std::list<Declaration*>& translationUnit ) {
	PassVisitor<GcTracer> tracer{ gc };
	acceptAll( const_cast<std::list<Declaration*>&>( translationUnit ), tracer );
	return gc;
}

// Local Variables: //
// tab-width: 4 //
// mode: c++ //
// compile-command: "make install" //
// End: //
