//
// Cforall Version 1.0.0 Copyright (C) 2015 University of Waterloo
//
// The contents of this file are covered under the licence agreement in the
// file "LICENCE" distributed with Cforall.
//
// specialize.c -- 
//
// Author           : Richard C. Bilson
// Created On       : Wed May 27 17:56:53 2015
// Last Modified By : Peter A. Buhr
// Last Modified On : Tue Mar  8 22:06:17 2016
// Update Count     : 3
//

/// void f( const int * );
/// 
/// void m()
/// {
///   f( 0 );
/// }

/// forall( dtype T ) T* f( T* );
/// void g( int* (*)(int*) );
/// 
/// int m() {
///   g( f );
/// }

/// void f1( void (*q)( forall( dtype U ) U* (*p)( U* ) ) );
/// void g1( int* (*)(int*) );
/// 
/// int m1() {
///   f1( g1 );
/// }

extern "C" {
	int printf( const char*, ... );
}

forall( otype T ) T f( T t )
{
	printf( "in f; sizeof T is %d\n", sizeof( T ) );
	return t;
}

void g( int (*p)(int) )
{
	printf( "g: f(7) returned %d\n", f(7) );
}

int main() {
	g( f );
}

// Local Variables: //
// tab-width: 4 //
// compile-command: "cfa specialize.c" //
// End: //
