open Printf

type s = { i : int; j : int }
let sv : s = { i = 3; j = 5 }
type adt =
	I of int |
	F of float |
	S of s
let adtprt( adtv : adt ) =
	match adtv with (* pattern matching *)
		I i -> printf "%d\n" i |
		F f -> printf "%g\n" f |
		S sv -> printf "%d %d\n" sv.i sv.j

let silly( adtv : adt ) =
	if adtv <= F(3.5) then
		printf "<= F\n"
	else if adtv >= S(sv) then
		printf ">= S\n"

let adtv : adt = I(3) let _ = adtprt( adtv ); silly( adtv )
let adtv : adt = F(3.5) let _ = adtprt( adtv ); silly( adtv )
let adtv : adt = S(sv) let _ = adtprt( adtv ); silly( adtv )

type week = Mon | Tue | Wed | Thu | Fri | Sat | Sun [@@deriving enumerate]
let _ = List.iter ( fun e -> printf "%d" (to_val e) ) all_of_week

let day : week = Mon

let take_class( d : week ) =
	if d <= Fri then
		printf "weekday\n"
	else if d >= Sat then
		printf "weekend\n";
	match d with
		Mon | Wed -> printf "CS442\n" |
		Tue | Thu -> printf "CS343\n" |
		Fri -> printf "Tutorial\n" |
		_ -> printf "Take a break\n"

let _ = take_class( Mon ); take_class( Sat );

type weekday = Mon | Tue | Wed | Thu | Fri
type weekend = Sat | Sun of float
type week = Weekday of weekday | Weekend of weekend
let day : week = Weekend (Sun 3.5)

let take_class( d : week ) =
	if d <= Weekday Fri then
		printf "weekday\n"
	else if d >= Weekend Sat then
		printf "weekend\n";
	match d with
		Weekday Mon | Weekday Wed -> printf "CS442\n" |
		Weekday Tue | Weekday Thu -> printf "CS343\n" |
		Weekday Fri -> printf "Tutorial\n" |
		_ -> printf "Take a break\n"
let _ = take_class( day )

let _ = for i = 1 to 10 do
	printf "%d, " i
done

(* Local Variables: *)
(* tab-width: 4 *)
(* compile-command: "ocaml test.ml" *)
(* End: *)
