//
// Cforall Version 1.0.0 Copyright (C) 2015 University of Waterloo
//
// The contents of this file are covered under the licence agreement in the
// file "LICENCE" distributed with Cforall.
//
// simpleGenericTriple.c --
//
// Author           : Rob Schluntz
// Created On       : Tue Nov 15 17:24:32 2016
// Last Modified By : Rob Schluntz
// Last Modified On : Tue Nov 15 17:27:28 2016
// Update Count     : 3
//

forall(otype T)
struct T3 {
	T f0, f1, f2;
};

forall(otype T | { T ?+?(T, T); })
T3(T) ?+?(T3(T) x, T3(T) y) {
	T3(T) z = { x.f0+y.f0, x.f1+y.f1, x.f2+y.f2 };
	return z;
}

int main() {
  int x1 = 123, x3 = 456;
  double x2 = 999.123;
  struct T3(int) L = { x1, x2, x3 };
  struct T3(int) R = { 9, 2, 3 };
  struct T3(int) ret = L+R;
  printf("%d %d %d\n", ret.f0, ret.f1, ret.f2);
}

// Local Variables: //
// tab-width: 4 //
// End: //
