//
// Cforall Version 1.0.0 Copyright (C) 2015 University of Waterloo
//
// The contents of this file are covered under the licence agreement in the
// file "LICENCE" distributed with Cforall.
//
// Constant.h --
//
// Author           : Richard C. Bilson
// Created On       : Mon May 18 07:44:20 2015
// Last Modified By : Peter A. Buhr
// Last Modified On : Sat Jul 22 09:54:46 2017
// Update Count     : 17
//

#pragma once

#include "SynTree.h"
#include "Visitor.h"
#include "Mutator.h"

class Constant {
  public:
	Constant( Type * type, std::string rep, unsigned long long val );
	Constant( Type * type, std::string rep, double val );
	Constant( const Constant & other );
	virtual ~Constant();

	Type * get_type() { return type; }
	void set_type( Type * newValue ) { type = newValue; }
	std::string & get_value() { return rep; }
	void set_value( std::string newValue ) { rep = newValue; }
	unsigned long long get_ival() const;
	double get_dval() const;

	/// generates a boolean constant of the given bool
	static Constant from_bool( bool b );
	/// generates an integer constant of the given int
	static Constant from_int( int i );
	/// generates an integer constant of the given unsigned long int
	static Constant from_ulong( unsigned long i );
	/// generates a floating point constant of the given double
	static Constant from_double( double d );

	/// generates a null pointer value for the given type. void * if omitted.
	static Constant null( Type * ptrtype = nullptr );

	virtual void accept( Visitor & v ) { v.visit( this ); }
	virtual Constant * acceptMutator( Mutator & m ) { return m.mutate( this ); }
	virtual void print( std::ostream & os ) const;
  private:
	Type * type;
	std::string rep;
	union Val {
		unsigned long long ival;
		double dval;
		Val( unsigned long long ival ) : ival( ival ) {}
		Val( double dval ) : dval( dval ) {}
	} val;
};

// Local Variables: //
// tab-width: 4 //
// mode: c++ //
// compile-command: "make install" //
// End: //
