//
// Cforall Version 1.0.0 Copyright (C) 2016 University of Waterloo
//
// The contents of this file are covered under the licence agreement in the
// file "LICENCE" distributed with Cforall.
//
// exception.h -- Builtins for exception handling.
//
// Author           : Andrew Beach
// Created On       : Mon Jun 26 15:11:00 2017
// Last Modified By : Andrew Beach
// Last Modified On : Mon Nov 26 15:11:00 2017
// Update Count     : 0
//

#ifndef EXCEPTION_H
#define EXCEPTION_H


// Later to be a special structure type.
typedef int exception;

#ifdef __CFORALL__
extern "BuiltinC" {
#endif

// Used in throw statement translation.
void __cfaehm__throw_termination(exception * except) __attribute__((noreturn));
void __cfaehm__rethrow_termination() __attribute__((noreturn));
void __cfaehm__throw_resumption(exception * except);

// Function catches termination exceptions.
void __cfaehm__try_terminate(
    void (*try_block)(),
    void (*catch_block)(int index, exception * except),
    int (*match_block)(exception * except));

// Data structure creates a list of resume handlers.
struct __cfaehm__try_resume_node {
    struct __cfaehm__try_resume_node * next;
    int (*handler)(exception * except);
};

void __cfaehm__try_resume_setup(
    struct __cfaehm__try_resume_node * node,
    int (*handler)(exception * except));
void __cfaehm__try_resume_cleanup(
    struct __cfaehm__try_resume_node * node);

// Check for a standard way to call fake deconstructors.
struct __cfaehm__cleanup_hook {
};

#ifdef __CFORALL__
}
#endif

#endif //EXCEPTION_H
