//
// Cforall Version 1.0.0 Copyright (C) 2017 University of Waterloo
//
// The contents of this file are covered under the licence agreement in the
// file "LICENCE" distributed with Cforall.
//
// literals.c --
//
// Author           : Peter A. Buhr
// Created On       : Sat Sep  9 16:34:38 2017
// Last Modified By : Peter A. Buhr
// Last Modified On : Sun Jul  1 15:12:15 2018
// Update Count     : 137
//

#ifdef __CFA__
#include <stdint.h>
#include <fstream.hfa>

void f( char v ) { sout | "char " | v | endl; }
void f( signed char v ) { sout | "signed char " | v | endl; }
void f( unsigned char v ) { sout | "unsigned char " | v | endl; }
void f( signed short v ) { sout | "signed short int" | v | endl; }
void f( unsigned short v ) { sout | "unsigned short int" | v | endl; }
void f( size_t v ) { sout | "size_t" | v | endl; }
#endif // __CFA__

//#define ERROR

int main() {
// integer literals

	// binary
	 0b01101011;   0b01101011u;   0b01101011l;   0b01101011ll;   0b01101011ul;   0b01101011lu;   0b01101011ull;   0b01101011llu;
	+0b01101011;  +0b01101011u;  +0b01101011l;  +0b01101011ll;  +0b01101011ul;  +0b01101011lu;  +0b01101011ull;  +0b01101011llu;
	-0b01101011;  -0b01101011u;  -0b01101011l;  -0b01101011ll;  -0b01101011ul;  -0b01101011lu;  -0b01101011ull;  -0b01101011llu;

	// octal
	 01234567;   01234567u;   01234567l;   01234567ll;   01234567ul;   01234567lu;   01234567ull;   01234567llu;
	+01234567;  +01234567u;  +01234567l;  +01234567ll;  +01234567ul;  +01234567lu;  +01234567ull;  +01234567llu;
	-01234567;  -01234567u;  -01234567l;  -01234567ll;  -01234567ul;  -01234567lu;  -01234567ull;  -01234567llu;

	// decimal
	 1234567890;   1234567890u;   1234567890l;   1234567890ll;   1234567890ul;   1234567890lu;   1234567890ull;   1234567890llu;
	+1234567890;  +1234567890u;  +1234567890l;  +1234567890ll;  +1234567890ul;  +1234567890lu;  +1234567890ull;  +1234567890llu;
	-1234567890;  -1234567890u;  -1234567890l;  -1234567890ll;  -1234567890ul;  -1234567890lu;  -1234567890ull;  -1234567890llu;

	// hexadecimal
	 0x0123456789abcdef;   0x0123456789abcdefu;   0x0123456789abcdefl;   0x0123456789abcdefll;   0x0123456789abcdeful;   0x0123456789abcdeflu;   0x0123456789abcdefull;   0x0123456789abcdefllu;
	+0x0123456789abcdef;  +0x0123456789abcdefu;  +0x0123456789abcdefl;  +0x0123456789abcdefll;  +0x0123456789abcdeful;  +0x0123456789abcdeflu;  +0x0123456789abcdefull;  +0x0123456789abcdefllu;
	-0x0123456789abcdef;  -0x0123456789abcdefu;  -0x0123456789abcdefl;  -0x0123456789abcdefll;  -0x0123456789abcdeful;  -0x0123456789abcdeflu;  -0x0123456789abcdefull;  -0x0123456789abcdefllu;

	 0x0123456789ABCDEF;   0x0123456789ABCDEFu;   0x0123456789ABCDEFl;   0x0123456789ABCDEFll;   0x0123456789ABCDEFul;   0x0123456789ABCDEFlu;   0x0123456789ABCDEFull;   0x0123456789ABCDEFllu;
	+0x0123456789ABCDEF;  +0x0123456789ABCDEFu;  +0x0123456789ABCDEFl;  +0x0123456789ABCDEFll;  +0x0123456789ABCDEFul;  +0x0123456789ABCDEFlu;  +0x0123456789ABCDEFull;  +0x0123456789ABCDEFllu;
	-0x0123456789ABCDEF;  -0x0123456789ABCDEFu;  -0x0123456789ABCDEFl;  -0x0123456789ABCDEFll;  -0x0123456789ABCDEFul;  -0x0123456789ABCDEFlu;  -0x0123456789ABCDEFull;  -0x0123456789ABCDEFllu;

	 0X0123456789abcdef;   0X0123456789abcdefu;   0X0123456789abcdefl;   0X0123456789abcdefll;   0X0123456789abcdeful;   0X0123456789abcdeflu;   0X0123456789abcdefull;   0X0123456789abcdefllu;
	+0X0123456789abcdef;  +0X0123456789abcdefu;  +0X0123456789abcdefl;  +0X0123456789abcdefll;  +0X0123456789abcdeful;  +0X0123456789abcdeflu;  +0X0123456789abcdefull;  +0X0123456789abcdefllu;
	-0X0123456789abcdef;  -0X0123456789abcdefu;  -0X0123456789abcdefl;  -0X0123456789abcdefll;  -0X0123456789abcdeful;  -0X0123456789abcdeflu;  -0X0123456789abcdefull;  -0X0123456789abcdefllu;

	 0X0123456789ABCDEF;   0X0123456789ABCDEFu;   0X0123456789ABCDEFl;   0X0123456789ABCDEFll;   0X0123456789ABCDEFul;   0X0123456789ABCDEFlu;   0X0123456789ABCDEFull;   0X0123456789ABCDEFllu;
	+0X0123456789ABCDEF;  +0X0123456789ABCDEFu;  +0X0123456789ABCDEFl;  +0X0123456789ABCDEFll;  +0X0123456789ABCDEFul;  +0X0123456789ABCDEFlu;  +0X0123456789ABCDEFull;  +0X0123456789ABCDEFllu;
	-0X0123456789ABCDEF;  -0X0123456789ABCDEFu;  -0X0123456789ABCDEFl;  -0X0123456789ABCDEFll;  -0X0123456789ABCDEFul;  -0X0123456789ABCDEFlu;  -0X0123456789ABCDEFull;  -0X0123456789ABCDEFllu;

// decimal floating literals

	 0123456789.;   0123456789.f;   0123456789.l;   0123456789.F;   0123456789.L;   0123456789.DL;
	+0123456789.;  +0123456789.f;  +0123456789.l;  +0123456789.F;  +0123456789.L;  +0123456789.DL;
	-0123456789.;  -0123456789.f;  -0123456789.l;  -0123456789.F;  -0123456789.L;  -0123456789.DL;

	 0123456789.e09;   0123456789.e09f;   0123456789.e09l;   0123456789.e09F;   0123456789.e09L;   0123456789.e09DL;
	+0123456789.e09;  +0123456789.e09f;  +0123456789.e09l;  +0123456789.e09F;  +0123456789.e09L;  +0123456789.e09DL;
	-0123456789.e09;  -0123456789.e09f;  -0123456789.e09l;  -0123456789.e09F;  -0123456789.e09L;  -0123456789.e09DL;

	 0123456789.e+09;   0123456789.e+09f;   0123456789.e+09l;   0123456789.e+09F;   0123456789.e+09L;   0123456789.e+09DL;
	+0123456789.e+09;  +0123456789.e+09f;  +0123456789.e+09l;  +0123456789.e+09F;  +0123456789.e+09L;  +0123456789.e+09DL;
	-0123456789.e+09;  -0123456789.e+09f;  -0123456789.e+09l;  -0123456789.e+09F;  -0123456789.e+09L;  -0123456789.e+09DL;

	 0123456789.e-09;   0123456789.e-09f;   0123456789.e-09l;   0123456789.e-09F;   0123456789.e-09L;   0123456789.e-09DL;
	+0123456789.e-09;  +0123456789.e-09f;  +0123456789.e-09l;  +0123456789.e-09F;  +0123456789.e-09L;  +0123456789.e-09DL;
	-0123456789.e-09;  -0123456789.e-09f;  -0123456789.e-09l;  -0123456789.e-09F;  -0123456789.e-09L;  -0123456789.e-09DL;

	 .0123456789;   .0123456789f;   .0123456789l;   .0123456789F;   .0123456789L;   .0123456789DL;
	+.0123456789;  +.0123456789f;  +.0123456789l;  +.0123456789F;  +.0123456789L;  +.0123456789DL;
	-.0123456789;  -.0123456789f;  -.0123456789l;  -.0123456789F;  -.0123456789L;  -.0123456789DL;

	 .0123456789e09;   .0123456789e09f;   .0123456789e09l;   .0123456789e09F;   .0123456789e09L;   .0123456789e09DL;
	+.0123456789e09;  +.0123456789e09f;  +.0123456789e09l;  +.0123456789e09F;  +.0123456789e09L;  +.0123456789e09DL;
	-.0123456789e09;  -.0123456789e09f;  -.0123456789e09l;  -.0123456789e09F;  -.0123456789e09L;  -.0123456789e09DL;

	 .0123456789E+09;   .0123456789E+09f;   .0123456789E+09l;   .0123456789E+09F;   .0123456789E+09L;   .0123456789E+09DL;
	+.0123456789E+09;  +.0123456789E+09f;  +.0123456789E+09l;  +.0123456789E+09F;  +.0123456789E+09L;  +.0123456789E+09DL;
	-.0123456789E+09;  -.0123456789E+09f;  -.0123456789E+09l;  -.0123456789E+09F;  -.0123456789E+09L;  -.0123456789E+09DL;

	 .0123456789E-09;   .0123456789E-09f;   .0123456789E-09l;   .0123456789E-09F;   .0123456789E-09L;   .0123456789E-09DL;
	-.0123456789E-09;  -.0123456789E-09f;  -.0123456789E-09l;  -.0123456789E-09F;  -.0123456789E-09L;  -.0123456789E-09DL;
	-.0123456789E-09;  -.0123456789E-09f;  -.0123456789E-09l;  -.0123456789E-09F;  -.0123456789E-09L;  -.0123456789E-09DL;

	 0123456789.0123456789;   0123456789.0123456789f;   0123456789.0123456789l;   0123456789.0123456789F;   0123456789.0123456789L;   0123456789.0123456789DL;
	+0123456789.0123456789;  +0123456789.0123456789f;  +0123456789.0123456789l;  +0123456789.0123456789F;  +0123456789.0123456789L;  +0123456789.0123456789DL;
	-0123456789.0123456789;  -0123456789.0123456789f;  -0123456789.0123456789l;  -0123456789.0123456789F;  -0123456789.0123456789L;  -0123456789.0123456789DL;

	 0123456789.0123456789E09;   0123456789.0123456789E09f;   0123456789.0123456789E09l;   0123456789.0123456789E09F;   0123456789.0123456789E09L;   0123456789.0123456789E09DL;
	+0123456789.0123456789E09;  +0123456789.0123456789E09f;  +0123456789.0123456789E09l;  +0123456789.0123456789E09F;  +0123456789.0123456789E09L;  +0123456789.0123456789E09DL;
	-0123456789.0123456789E09;  -0123456789.0123456789E09f;  -0123456789.0123456789E09l;  -0123456789.0123456789E09F;  -0123456789.0123456789E09L;  -0123456789.0123456789E09DL;

	 0123456789.0123456789E+09;   0123456789.0123456789E+09f;   0123456789.0123456789E+09l;   0123456789.0123456789E+09F;   0123456789.0123456789E+09L;   0123456789.0123456789E+09DL;
	+0123456789.0123456789E+09;  +0123456789.0123456789E+09f;  +0123456789.0123456789E+09l;  +0123456789.0123456789E+09F;  +0123456789.0123456789E+09L;  +0123456789.0123456789E+09DL;
	-0123456789.0123456789E+09;  -0123456789.0123456789E+09f;  -0123456789.0123456789E+09l;  -0123456789.0123456789E+09F;  -0123456789.0123456789E+09L;  -0123456789.0123456789E+09DL;

	 0123456789.0123456789E-09;   0123456789.0123456789E-09f;   0123456789.0123456789E-09l;   0123456789.0123456789E-09F;   0123456789.0123456789E-09L;   0123456789.0123456789E-09DL;
	+0123456789.0123456789E-09;  +0123456789.0123456789E-09f;  +0123456789.0123456789E-09l;  +0123456789.0123456789E-09F;  +0123456789.0123456789E-09L;  +0123456789.0123456789E-09DL;
	-0123456789.0123456789E-09;  -0123456789.0123456789E-09f;  -0123456789.0123456789E-09l;  -0123456789.0123456789E-09F;  -0123456789.0123456789E-09L;  -0123456789.0123456789E-09DL;

// hexadecimal floating literals, must have exponent

	 0x0123456789.p09;   0x0123456789.p09f;   0x0123456789.p09l;   0x0123456789.p09F;   0x0123456789.p09L;
	+0x0123456789.p09;  +0x0123456789.p09f;  +0x0123456789.p09l;  +0x0123456789.p09F;  +0x0123456789.p09L;
	-0x0123456789.p09;  -0x0123456789.p09f;  -0x0123456789.p09l;  -0x0123456789.p09F;  -0x0123456789.p09L;

	 0x0123456789.p+09;   0x0123456789.p+09f;   0x0123456789.p+09l;   0x0123456789.p+09F;   0x0123456789.p+09L;
	+0x0123456789.p+09;  +0x0123456789.p+09f;  +0x0123456789.p+09l;  +0x0123456789.p+09F;  +0x0123456789.p+09L;
	-0x0123456789.p+09;  -0x0123456789.p+09f;  -0x0123456789.p+09l;  -0x0123456789.p+09F;  -0x0123456789.p+09L;

	 0x0123456789.p-09;   0x0123456789.p-09f;   0x0123456789.p-09l;   0x0123456789.p-09F;   0x0123456789.p-09L;
	+0x0123456789.p-09;  +0x0123456789.p-09f;  +0x0123456789.p-09l;  +0x0123456789.p-09F;  +0x0123456789.p-09L;
	-0x0123456789.p-09;  -0x0123456789.p-09f;  -0x0123456789.p-09l;  -0x0123456789.p-09F;  -0x0123456789.p-09L;

	 0x.0123456789p09;   0x.0123456789p09f;   0x.0123456789p09l;   0x.0123456789p09F;   0x.0123456789p09L;
	+0x.0123456789p09;  +0x.0123456789p09f;  +0x.0123456789p09l;  +0x.0123456789p09F;  +0x.0123456789p09L;
	-0x.0123456789p09;  -0x.0123456789p09f;  -0x.0123456789p09l;  -0x.0123456789p09F;  -0x.0123456789p09L;

	 0x.0123456789p+09;   0x.0123456789p+09f;   0x.0123456789p+09l;   0x.0123456789p+09F;   0x.0123456789p+09L;
	+0x.0123456789p+09;  +0x.0123456789p+09f;  +0x.0123456789p+09l;  +0x.0123456789p+09F;  +0x.0123456789p+09L;
	-0x.0123456789p+09;  -0x.0123456789p+09f;  -0x.0123456789p+09l;  -0x.0123456789p+09F;  -0x.0123456789p+09L;

	 0x.0123456789P-09;   0x.0123456789P-09f;   0x.0123456789P-09l;   0x.0123456789P-09F;   0x.0123456789P-09L;
	+0x.0123456789P-09;  +0x.0123456789P-09f;  +0x.0123456789P-09l;  +0x.0123456789P-09F;  +0x.0123456789P-09L;
	-0x.0123456789P-09;  -0x.0123456789P-09f;  -0x.0123456789P-09l;  -0x.0123456789P-09F;  -0x.0123456789P-09L;

	 0X0123456789.0123456789P09;   0X0123456789.0123456789P09f;   0X0123456789.0123456789P09l;   0X0123456789.0123456789P09F;   0X0123456789.0123456789P09L;
	+0X0123456789.0123456789P09;  +0X0123456789.0123456789P09f;  +0X0123456789.0123456789P09l;  +0X0123456789.0123456789P09F;  +0X0123456789.0123456789P09L;
	-0X0123456789.0123456789P09;  -0X0123456789.0123456789P09f;  -0X0123456789.0123456789P09l;  -0X0123456789.0123456789P09F;  -0X0123456789.0123456789P09L;

	 0X0123456789.0123456789P+09;   0X0123456789.0123456789P+09f;   0X0123456789.0123456789P+09l;   0X0123456789.0123456789P+09F;   0X0123456789.0123456789P+09L;
	+0X0123456789.0123456789P+09;  +0X0123456789.0123456789P+09f;  +0X0123456789.0123456789P+09l;  +0X0123456789.0123456789P+09F;  +0X0123456789.0123456789P+09L;
	-0X0123456789.0123456789P+09;  -0X0123456789.0123456789P+09f;  -0X0123456789.0123456789P+09l;  -0X0123456789.0123456789P+09F;  -0X0123456789.0123456789P+09L;

	 0X0123456789.0123456789P-09;   0X0123456789.0123456789P-09f;   0X0123456789.0123456789P-09l;   0X0123456789.0123456789P-09F;   0X0123456789.0123456789P-09L;
	+0X0123456789.0123456789P-09;  +0X0123456789.0123456789P-09f;  +0X0123456789.0123456789P-09l;  +0X0123456789.0123456789P-09F;  +0X0123456789.0123456789P-09L;
	-0X0123456789.0123456789P-09;  -0X0123456789.0123456789P-09f;  -0X0123456789.0123456789P-09l;  -0X0123456789.0123456789P-09F;  -0X0123456789.0123456789P-09L;

#ifdef __CFA__
// fixed-size length

	// binary
	 0b01101011_l8;   0b01101011_l16;   0b01101011_l32;   0b01101011_l64;   0b01101011_l8u;   0b01101011_ul16;   0b01101011_l32u;   0b01101011_ul64;
	+0b01101011_l8;  +0b01101011_l16;  +0b01101011_l32;  +0b01101011_l64;  +0b01101011_l8u;  +0b01101011_ul16;  +0b01101011_l32u;  +0b01101011_ul64;
	-0b01101011_l8;  -0b01101011_l16;  -0b01101011_l32;  -0b01101011_l64;  -0b01101011_l8u;  -0b01101011_ul16;  -0b01101011_l32u;  -0b01101011_ul64;

#ifdef __LP64__ // 64-bit processor
	0b01101011_l128;   0b01101011_ul128;
	+0b01101011_l128;  +0b01101011_ul128;
	-0b01101011_l128;  -0b01101011_ul128;
#endif // __LP64__

	// octal
	 01234567_l8;   01234567_l16;   01234567_l32;   01234567_l64;   01234567_l8u;   01234567_ul16;   01234567_l32u;   01234567_ul64;
	+01234567_l8;  +01234567_l16;  +01234567_l32;  +01234567_l64;  +01234567_l8u;  +01234567_ul16;  +01234567_l32u;  +01234567_ul64;
	-01234567_l8;  -01234567_l16;  -01234567_l32;  -01234567_l64;  -01234567_l8u;  -01234567_ul16;  -01234567_l32u;  -01234567_ul64;

#ifdef __LP64__ // 64-bit processor
	01234567_l128;   01234567_ul128;
	+01234567_l128;  +01234567_ul128;
	-01234567_l128;  -01234567_ul128;
#endif // __LP64__

	// decimal
	 1234567890L8;   1234567890L16;   1234567890l32;   1234567890l64;   1234567890UL8;   1234567890L16U;   1234567890Ul32;   1234567890l64u;
	+1234567890L8;  +1234567890L16;  +1234567890l32;  +1234567890l64;  +1234567890UL8;  +1234567890L16U;  +1234567890Ul32;  +1234567890l64u;
	-1234567890L8;  -1234567890L16;  -1234567890l32;  -1234567890l64;  -1234567890UL8;  -1234567890L16U;  -1234567890Ul32;  -1234567890l64u;

#ifdef __LP64__ // 64-bit processor
	1234567890l128;   1234567890l128u;
	+1234567890l128;  +1234567890l128u;
	-1234567890l128;  -1234567890l128u;
#endif // __LP64__

	// hexadecimal
	 0x0123456789abcdef_l8;   0x0123456789abcdef_l16;   0x0123456789abcdefl32;   0x0123456789abcdefl64;   0x0123456789abcdef_ul8;   0x0123456789abcdef_l16u;   0x0123456789abcdeful32;   0x0123456789abcdefl64u;
	+0x0123456789abcdef_l8;  +0x0123456789abcdef_l16;  +0x0123456789abcdefl32;  +0x0123456789abcdefl64;  +0x0123456789abcdef_ul8;  +0x0123456789abcdef_l16u;  +0x0123456789abcdeful32;  +0x0123456789abcdefl64u;
	-0x0123456789abcdef_l8;  -0x0123456789abcdef_l16;  -0x0123456789abcdefl32;  -0x0123456789abcdefl64;  -0x0123456789abcdef_ul8;  -0x0123456789abcdef_l16u;  -0x0123456789abcdeful32;  -0x0123456789abcdefl64u;

	 0x0123456789ABCDEF_l8;   0x0123456789ABCDEF_l16;   0x0123456789ABCDEFl32;   0x0123456789ABCDEFl64;   0x0123456789ABCDEF_ul8;   0x0123456789ABCDEF_l16u;   0x0123456789ABCDEFul32;   0x0123456789ABCDEFl64u;
	+0x0123456789ABCDEF_l8;  +0x0123456789ABCDEF_l16;  +0x0123456789ABCDEFl32;  +0x0123456789ABCDEFl64;  +0x0123456789ABCDEF_ul8;  +0x0123456789ABCDEF_l16u;  +0x0123456789ABCDEFul32;  +0x0123456789ABCDEFl64u;
	-0x0123456789ABCDEF_l8;  -0x0123456789ABCDEF_l16;  -0x0123456789ABCDEFl32;  -0x0123456789ABCDEFl64;  -0x0123456789ABCDEF_ul8;  -0x0123456789ABCDEF_l16u;  -0x0123456789ABCDEFul32;  -0x0123456789ABCDEFl64u;

	 0X0123456789abcdef_l8;   0X0123456789abcdef_l16;   0X0123456789abcdefl32;   0X0123456789abcdefl64;   0X0123456789abcdef_ul8;   0X0123456789abcdef_l16u;   0X0123456789abcdeful32;   0X0123456789abcdefl64u;
	+0X0123456789abcdef_l8;  +0X0123456789abcdef_l16;  +0X0123456789abcdefl32;  +0X0123456789abcdefl64;  +0X0123456789abcdef_ul8;  +0X0123456789abcdef_l16u;  +0X0123456789abcdeful32;  +0X0123456789abcdefl64u;
	-0X0123456789abcdef_l8;  -0X0123456789abcdef_l16;  -0X0123456789abcdefl32;  -0X0123456789abcdefl64;  -0X0123456789abcdef_ul8;  -0X0123456789abcdef_l16u;  -0X0123456789abcdeful32;  -0X0123456789abcdefl64u;

	 0X0123456789ABCDEF_l8;   0X0123456789ABCDEF_l16;   0X0123456789ABCDEFl32;   0X0123456789ABCDEFl64;   0X0123456789ABCDEF_ul8;   0X0123456789ABCDEF_l16u;   0X0123456789ABCDEFul32;   0X0123456789ABCDEFl64u;
	+0X0123456789ABCDEF_l8;  +0X0123456789ABCDEF_l16;  +0X0123456789ABCDEFl32;  +0X0123456789ABCDEFl64;  +0X0123456789ABCDEF_ul8;  +0X0123456789ABCDEF_l16u;  +0X0123456789ABCDEFul32;  +0X0123456789ABCDEFl64u;
	-0X0123456789ABCDEF_l8;  -0X0123456789ABCDEF_l16;  -0X0123456789ABCDEFl32;  -0X0123456789ABCDEFl64;  -0X0123456789ABCDEF_ul8;  -0X0123456789ABCDEF_l16u;  -0X0123456789ABCDEFul32;  -0X0123456789ABCDEFl64u;

	// floating
	 0123456789.l32;   0123456789.l64;   0123456789.l80;   0123456789.l128;
	+0123456789.l32;  +0123456789.l64;  +0123456789.l80;  +0123456789.l128;
	-0123456789.l32;  -0123456789.l64;  -0123456789.l80;  -0123456789.l128;

	 0123456789.e09L32;    0123456789.e09L64;    0123456789.e09L80;    0123456789.e09L128;
	+0123456789.e+09L32;  +0123456789.e+09L64;  +0123456789.e+09L80;  +0123456789.e+09L128;
	-0123456789.e-09L32;  -0123456789.e-09L64;  -0123456789.e-09L80;  -0123456789.e-09L128;

	 .0123456789e09L32;    .0123456789e09L64;    .0123456789e09L80;    .0123456789e09L128;
	+.0123456789E+09L32;  +.0123456789E+09L64;  +.0123456789E+09L80;  +.0123456789E+09L128;
	-.0123456789E-09L32;  -.0123456789E-09L64;  -.0123456789E-09L80;  -.0123456789E-09L128;

	 0123456789.0123456789L32;       0123456789.0123456789L64;       0123456789.0123456789L80;       0123456789.0123456789L128;
	+0123456789.0123456789E09L32;   +0123456789.0123456789E09L64;   +0123456789.0123456789E09L80;   +0123456789.0123456789E09L128;
	-0123456789.0123456789E+09L32;  -0123456789.0123456789E+09L64;  -0123456789.0123456789E+09L80;  -0123456789.0123456789E+09L128;
	 0123456789.0123456789E-09L32;   0123456789.0123456789E-09L64;   0123456789.0123456789E-09L80;   0123456789.0123456789E-09L128;

	 0x0123456789.p09l32;   0x0123456789.p09l64;   0x0123456789.p09l80;   0x0123456789.p09l128;
	+0x0123456789.p09l32;  +0x0123456789.p09l64;  +0x0123456789.p09l80;  +0x0123456789.p09l128;
	-0x0123456789.p09l32;  -0x0123456789.p09l64;  -0x0123456789.p09l80;  -0x0123456789.p09l128;

	 0x0123456789.p+09l32;   0x0123456789.p+09L64;   0x0123456789.p+09L80;   0x0123456789.p+09L128;
	+0x0123456789.p-09l32;  +0x0123456789.p-09L64;  +0x0123456789.p-09L80;  +0x0123456789.p-09L128;
	-0x.0123456789p09l32;   -0x.0123456789p09L64;   -0x.0123456789p09L80;   -0x.0123456789p09L128;

// char, short, int suffix overloading

	f( 'a' );
	f( 20_hh );
	f( 21_hhu );
	f( 22_h );
	f( 23_uh );
	f( 24z );
#endif // __CFA__

// character literals

	' ';  'a';  '"';  '_';
	'\'';  '\"';  '\?';  '\\';							// simple escape
	'\a';  '\b';  '\e'; /* GCC */  '\f';  '\n';  '\r';  '\t';  '\v';
	'\0'; '\377';										// octal escape
	'\xf';  '\xff';										// hex escape

	u' ';  u'a';  u'"';  u'_';
	U' ';  U'a';  U'"';  U'_';
	L' ';  L'a';  L'"';  L'_';

// warnings/errors

#ifdef ERROR
	'';													// empty character
	'aa';												// multi-character
	'a\na';												// multi-character, embedded escape
	'a\0a';
	'\xfff';											// hex escape out of range
	'_\377_';											// multi-character
	'_\xff_';
	'\xffff';											// hex escape out of range
	'a\xff34w';
	'\xf_f';											// multi-character
	'\xff_ff';
#endif // ERROR

// string literals

	" ";  "a";  "'";  '_';  "abcdefghijklmnopqrstuvwxyz";
	"";  "aa";  "a\na";  "a\0a";  "_\377_";  "_\xff_";  "\xf_f";
	"\'";  "\"";  "\?";  "\\";							// simple escape
	"\a";  "\b";  "\e"; /* GCC */  "\f";  "\n";  "\r";  "\t";  "\v";
	"\0";  "\377";										// octal escape
	"\xf";  "\xff";										// hex escape

	u8" ";  u8"a";  u8"'";  u'_';  u8"abcdefghijklmnopqrstuvwxyz";
	u" ";  u"a";  u"'";  u'_';  u"abcdefghijklmnopqrstuvwxyz";
	U" ";  U"a";  U"'";  U'_';  U"abcdefghijklmnopqrstuvwxyz";
	L" ";  L"a";  L"'";  L'_';  L"abcdefghijklmnopqrstuvwxyz";

	"\xFF";  u"\xFFFF";  U"\xFFFFFFFF";  L"\xFFFFFFFF";	// maximum size

	// concatenation

	"\x12" "3";											// 2 characters not 1!

	"a" "b" u8"c";
	"a" u8"b" "c";
	"a" u8"b" u8"c";
	u8"a" "b" u8"c";
	u8"a" u8"b" u8"c";

	"a" "b" u"c";
	"a" u"b" "c";
	"a" u"b" u"c";
	u"a" "b" u"c";
	u"a" u"b" u"c";

	"a" "b" U"c";
	"a" U"b" "c";
	"a" U"b" U"c";
	U"a" "b" U"c";
	U"a" U"b" U"c";

	"a" "b" L"c";
	"a" L"b" "c";
	"a" L"b" L"c";
	L"a" "b" L"c";
	L"a" L"b" L"c";

// warnings/errors

#ifdef ERROR
	"\xff_ff";
	"\xfff";				// hex escape out of range
	"a\xff34w";
	"\xffff";
#endif // ERROR
}

// Local Variables: //
// tab-width: 4 //
// compile-command: "cfa literals.c" //
// End: //
