#include <glm/glm.hpp>
#include <iostream>

using namespace glm;

std::ostream& operator<<(std::ostream& os, glm::tvec2<int>& v) {
    os << "<" << v.x << "," << v.y << ">";
    return os;
}
std::ostream& operator<<(std::ostream& os, glm::tvec2<int>&& v) {
    os << "<" << v.x << "," << v.y << ">";
    return os;
}

int length_squared(glm::tvec2<float> v) {
    return dot(v, v);
}

// tvec2<int> project(glm::tvec2<int> u, glm::tvec2<int> v) {
//     return normalize(v) * dot(u, normalize(v));
// }

int main(void) {
    tvec2<int> v1 = {1,2};
    std::cout << "ctor(x,y):" << v1 << std::endl;

    tvec2<int> v2 = v1;
    std::cout << "copy ctor:" << v2 << std::endl;

    v2 = (tvec2<int>){3, 4};
    std::cout << "assignment:" << v2 << std::endl;

    v2 = v1;
    std::cout << "move assignment:" << v2 << std::endl;


                // NOT SUPPORTED BY GLM
    // tvec2<int> v3 = 0;
    // std::cout << "zero-init:" << v3 << std::endl;

    // v1 = 0;
    // std::cout << "zero-assign:" << v1 << std::endl;

    // tvec2<int> v4 = {1.23f};
    // std::cout << "fill-ctor:" << v4 << std::endl;


    v1 = (tvec2<int>){1, 3};
    std::cout << "?-?:" << (v1 - (tvec2<int>){1003, -14}) << std::endl;

    v1 -= (tvec2<int>){1003, -14};
    std::cout << "?-=?:" << v1 << std::endl;

    v1 = -v1;
    std::cout << "-?:" << v1 << std::endl;

    v1 = (tvec2<int>){1, 3};
    std::cout << "?+?:" << (v1 + (tvec2<int>){1003, -14}) << std::endl;

    v1 += (tvec2<int>){1003, -14};
    std::cout << "?+=?:" << v1 << std::endl;

    v1 = (tvec2<int>){15, 275};
    std::cout << "v*s:" << v1 * 3 << std::endl;

    std::cout << "s*v:" << 3 * v1 << std::endl;

    v1 *= 3;
    std::cout << "?*=?:" << v1 << std::endl;

    v1 = (tvec2<int>){21, -10};
    std::cout << "?/?:" << (v1 / 3) << std::endl;

    v1 /= 3;
    std::cout << "?/=?:" << v1 << std::endl;

    //      FORCE GLM TO FLOAT, BUT WORKS
    tvec2<float> v1_f = (tvec2<float>){2.f, 3};
    tvec2<float> v2_f = (tvec2<float>){-3.f, 2.f};
    std::cout << "dot_1:" << dot(v1_f, v2_f) << std::endl;

    v2_f = (tvec2<float>){13, 2};
    std::cout << "dot_2:" << dot(v1_f, v2_f) << std::endl;


    //      NOT IN GLM BUT
    //      USES DOT, BUT THAT'S FLOATING-POINT ONLY!
    std::cout << "length_squared:" << length_squared(v1_f) << std::endl;

    //      FLOATING-POINT ONLY GLM
    // v1 = (tvec2<int>){100, -101};
    // v2 = (tvec2<int>){6, 3};
    // std::cout << "distance:" << distance(v1, v2) << std::endl;
    //
    // std::cout << "normalize:" << normalize(v2) << std::endl;
    //
    // v1 = (tvec2<int>){1,0};
    // std::cout << "normalize_2:" << normalize(v1) << std::endl;
    //
    // std::cout << "project:" << project((tvec2<int>){5,6}, (tvec2<int>){1, 0}) << std::endl;
    // std::cout << "project_2:" << project((tvec2<int>){5,6}, (tvec2<int>){1, 1}) << std::endl;
    //
    // v1 = (tvec2<int>){5,6};
    // v2 = (tvec2<int>){1,0};
    // std::cout << "reflect:" << reflect(v1,v2) << std::endl;
    //
    // v2 = (tvec2<int>){0,-1};
    // std::cout << "refract:" << refract(v1,normalize(v2),1) << std::endl;
    // std::cout << "refract:" << refract(v1,normalize(v2),1.f/1.33f) << std::endl;
    //
    //
    //      FLOATING-POINT ONLY IN GLM BUT JUST USES DOT SO...
    tvec2<float> geometric_normal = {5,6};
    tvec2<float> perturbed_normal = {4,5};
    tvec2<float> eyeline = {-1,0};
    std::cout << "faceforward_nochange:" << faceforward(perturbed_normal, eyeline, geometric_normal) << std::endl;

    eyeline = (tvec2<int>){1,0};
    std::cout << "faceforward_flip:" << faceforward(perturbed_normal, eyeline, geometric_normal) << std::endl;
}
