//
// Cforall Version 1.0.0 Copyright (C) 2016 University of Waterloo
//
// The contents of this file are covered under the licence agreement in the
// file "LICENCE" distributed with Cforall.
//
// libdebug.h --
//
// Author           : Thierry Delisle
// Created On       : Mon Nov 28 12:27:26 2016
// Last Modified By : Peter A. Buhr
// Last Modified On : Sat Jul 22 10:02:24 2017
// Update Count     : 1
//

#pragma once

#ifdef __CFA_DEBUG__
	#define LIB_DEBUG_DO(...) __VA_ARGS__
	#define LIB_NO_DEBUG_DO(...)
	#define DEBUG_CTX __PRETTY_FUNCTION__
	#define DEBUG_CTX2 , __PRETTY_FUNCTION__
	#define DEBUG_CTX_PARAM const char * caller
	#define DEBUG_CTX_PARAM2 , const char * caller
#else
	#define LIB_DEBUG_DO(...)
	#define LIB_NO_DEBUG_DO(...) __VA_ARGS__
	#define DEBUG_CTX
	#define DEBUG_CTX2
	#define DEBUG_CTX_PARAM
	#define DEBUG_CTX_PARAM2
#endif

#if !defined(NDEBUG) && (defined(__CFA_DEBUG__) || defined(__CFA_VERIFY__))
	#define verify(x) assert(x)
	#define verifyf(x, ...) assertf(x, __VA_ARGS__)
#else
	#define verify(x)
	#define verifyf(x, ...)
#endif


#ifdef __cforall
extern "C" {
#endif
      #include <stdarg.h>

      extern void __lib_debug_write( int fd, const char *buffer, int len );
      extern void __lib_debug_acquire();
      extern void __lib_debug_release();
      extern void __lib_debug_print_safe  ( const char fmt[], ... ) __attribute__(( format (printf, 1, 2) ));
      extern void __lib_debug_print_nolock( const char fmt[], ... ) __attribute__(( format (printf, 1, 2) ));
      extern void __lib_debug_print_vararg( const char fmt[], va_list arg );
      extern void __lib_debug_print_buffer( char buffer[], int buffer_size, const char fmt[], ... ) __attribute__(( format (printf, 3, 4) ));
#ifdef __cforall
}
#endif

#ifdef __CFA_DEBUG_PRINT__
	#define LIB_DEBUG_WRITE( fd, buffer, len )     __lib_debug_write( fd, buffer, len )
	#define LIB_DEBUG_ACQUIRE()                    __lib_debug_acquire()
	#define LIB_DEBUG_RELEASE()                    __lib_debug_release()
	#define LIB_DEBUG_PRINT_SAFE(...)              __lib_debug_print_safe   (__VA_ARGS__)
	#define LIB_DEBUG_PRINT_NOLOCK(...)            __lib_debug_print_nolock (__VA_ARGS__)
	#define LIB_DEBUG_PRINT_BUFFER(...)            __lib_debug_print_buffer (__VA_ARGS__)
	#define LIB_DEBUG_PRINT_BUFFER_DECL(fd, ...)   char text[256]; int len = snprintf( text, 256, __VA_ARGS__ ); __lib_debug_write( fd, text, len );
	#define LIB_DEBUG_PRINT_BUFFER_LOCAL(fd, ...)  len = snprintf( text, 256, __VA_ARGS__ ); __lib_debug_write( fd, text, len );
#else
	#define LIB_DEBUG_WRITE(...)               ((void)0)
	#define LIB_DEBUG_ACQUIRE()                ((void)0)
	#define LIB_DEBUG_RELEASE()                ((void)0)
	#define LIB_DEBUG_PRINT_SAFE(...)          ((void)0)
	#define LIB_DEBUG_PRINT_NOLOCK(...)        ((void)0)
	#define LIB_DEBUG_PRINT_BUFFER(...)        ((void)0)
	#define LIB_DEBUG_PRINT_BUFFER_DECL(...)   ((void)0)
	#define LIB_DEBUG_PRINT_BUFFER_LOCAL(...)  ((void)0)
#endif

// Local Variables: //
// mode: c //
// tab-width: 4 //
// End: //
