
m4_define([M4CFA_PARSE_PREFIX], [
	if test "x$prefix" = "xNONE"; then
		cfa_prefix=${ac_default_prefix}
	else
		cfa_prefix=${prefix}
	fi
	cfa_prefix="$(readlink -f ${cfa_prefix})/"
	AC_DEFINE_UNQUOTED(CFA_PREFIX, "${cfa_prefix}", [Location of cfa install.])
	AC_SUBST(CFA_PREFIX, ${cfa_prefix})

	if test "$includedir" = '${prefix}/include'; then
		cfa_incdir="${cfa_prefix}/include/${cfa_name}"
	else
		cfa_incdir=${includedir}
	fi
	cfa_incdir="$(readlink -f ${cfa_incdir})/"
	AC_DEFINE_UNQUOTED(CFA_INCDIR, "${cfa_incdir}", [Location of include files.])
	AC_SUBST(CFA_INCDIR, ${cfa_incdir})

	if test "$bindir" = '${exec_prefix}/bin'; then
		cfa_bindir="${cfa_prefix}/bin"
	else
		cfa_bindir=${bindir}
	fi
	cfa_bindir="$(readlink -f ${cfa_bindir})/"
	AC_DEFINE_UNQUOTED(CFA_BINDIR, "${cfa_bindir}", [Location of cfa command.])
	AC_SUBST(CFA_BINDIR, ${cfa_bindir})

	if test "$libdir" = '${exec_prefix}/lib'; then
		if test "${ARCHITECTURE}" != ""; then
			cfa_libdir="${cfa_prefix}/lib/${cfa_name}/${ARCHITECTURE}-${CONFIGURATION}/"
		else
			cfa_libdir="${cfa_prefix}/lib/${cfa_name}/"
		fi
	else
		cfa_libdir="${libdir}/${ARCHITECTURE}${CONFIGURATION}"
	fi
	cfa_libdir="$(readlink -f ${cfa_libdir})/"
	AC_DEFINE_UNQUOTED(CFA_LIBDIR, "${cfa_libdir}", [Location of cc1 and cfa-cpp commands.])
	AC_SUBST(CFA_LIBDIR, ${cfa_libdir})
])

m4_define([M4CFA_PROGRAM_NAME], [
	if test "${program_transform_name}" = ""; then
	AC_MSG_ERROR([Program transform not supported.
			Use --with-cfa-name='[[Desired name here]]' instead])
	fi

	#Define the new name of the installed command
	AC_ARG_WITH(cfa-name,
		[  --with-cfa-name=NAME     NAME too which cfa will be installed],
		cfa_name=$withval, cfa_name="cfa")

	AC_SUBST(CFA_NAME, ${cfa_name})
])

AC_DEFUN([M4CFA_CANNON_CPU], [
	case $arch_name in
		"x64"        ) cannon_arch_name="x64";;
		"x86-64"     ) cannon_arch_name="x64";;
		"x86_64"     ) cannon_arch_name="x64";;
		"x86"        ) cannon_arch_name="x86";;
		"i386"       ) cannon_arch_name="x86";;
		"i486"       ) cannon_arch_name="x86";;
		"i686"       ) cannon_arch_name="x86";;
		"Intel 80386") cannon_arch_name="x86";;
		"arm"        ) cannon_arch_name="arm";;
		"ARM"        ) cannon_arch_name="arm";;
		*)
		>&2 echo "Unkown architecture " $arch_name;
		exit 1
		;;
	esac
])