#include <fstream>
#include <kernel>
#include <monitor>
#include <thread>

monitor global_t {};

global_t globalA;
global_t globalB;
global_t globalC;

condition condAB, condAC, condBC, condABC;

thread Signaler {};
thread WaiterAB {};
thread WaiterAC {};
thread WaiterBC {};
thread WaiterABC{};

int state;

/*
multi phase
*/

//----------------------------------------------------------------------------------------------------
// Tools
void signal( condition * cond, global_t * mutex a, global_t * mutex b ) {
	signal( cond );
}

void signal( condition * cond, global_t * mutex a, global_t * mutex b, global_t * mutex c ) {
	signal( cond );
}

void wait( condition * cond, global_t * mutex a, global_t * mutex b ) {
	state++;
	sout | "Waiting" | state | endl;
	wait( cond );
	sout | "Waking" | state | endl;
	state--;
}

void wait( condition * cond, global_t * mutex a, global_t * mutex b, global_t * mutex c ) {
	state++;
	sout | "Waiting" | state | endl;
	wait( cond );
	sout | "Waking" | state | endl;
	state--;
}

//----------------------------------------------------------------------------------------------------
// Signaler
// signals respectively AB, AC, BC, ABC
void signalerABC( global_t * mutex a, global_t * mutex b, global_t * mutex c ) {
	sout | "Signaling ABC" | endl;
	signal( &condABC, a, b, c );
	sout | "Signaling AB" | endl;
	signal( &condAB , a, b );
	sout | "Signaling BC" | endl;
	signal( &condBC , b, c );
	sout | "Signaling AC" | endl;
	signal( &condAC , a, c );
}

void signalerAB( global_t * mutex a, global_t * mutex b, global_t * c ) {
	signalerABC(a, b, c);
}

void signalerA( global_t * mutex a, global_t * b, global_t * c ) {
	signalerAB (a, b, c);
}

void main( Signaler* this ) {
	while( state != 4 ) { yield(); }
	signalerA( &globalA, &globalB, &globalC );
}

//----------------------------------------------------------------------------------------------------
// Waiter ABC
void main( WaiterABC* this ) {
	while( state != 0 ) { yield(); }
	wait( &condABC, &globalA, &globalB, &globalC );
}

//----------------------------------------------------------------------------------------------------
// Waiter AB
void main( WaiterAB* this ) {
	while( state != 1 ) { yield(); }
	wait( &condAB , &globalA, &globalB );
}

//----------------------------------------------------------------------------------------------------
// Waiter AC
void main( WaiterAC* this ) {
	while( state != 2 ) { yield(); }
	wait( &condAC , &globalA, &globalC );
}

//----------------------------------------------------------------------------------------------------
// Waiter BC
void main( WaiterBC* this ) {
	while( state != 3 ) { yield(); }
	wait( &condBC , &globalB, &globalC );
}

//----------------------------------------------------------------------------------------------------
// Main
int main(int argc, char* argv[]) {
	state = 0;
	processor p;
	{
		WaiterABC a;
		WaiterAB  b;
		WaiterBC  c;
		WaiterAC  d;
		Signaler  e;
	}
}