void foo(int *) {}
void bar(void *) {}
forall(otype T) void baz(T *);
forall(dtype T) void qux(T *);
forall(dtype T | sized(T)) void quux(T *);

int main() {
	int *i;
	void *v;

	// okay
	foo(i);
	bar(i);
	baz(i);
	qux(i);
	quux(i);

	bar(v);
	qux(v);
	foo(v); // questionable, but works at the moment for C compatibility

	// bad
	baz(v);
	quux(v);
}

forall(otype T)
void baz(T * x) {
	// okay
	bar(x);
	baz(x);
	qux(x);
	quux(x);
}

forall(dtype T)
void qux(T * y) {
	// okay
	bar(y);
	qux(y);

	// bad
	baz(y);
	quux(y);
}

forall(dtype T | sized(T))
void qux(T * z) {
	// okay
	bar(z);
	qux(z);
	quux(z);

	// bad
	baz(z);
}

