//
// Cforall Version 1.0.0 Copyright (C) 2015 University of Waterloo
//
// The contents of this file are covered under the licence agreement in the
// file "LICENCE" distributed with Cforall.
//
// FindOpenVars.cc --
//
// Author           : Richard C. Bilson
// Created On       : Sun May 17 09:42:48 2015
// Last Modified By : Peter A. Buhr
// Last Modified On : Sun May 17 09:45:25 2015
// Update Count     : 3
//

#include "FindOpenVars.h"
#include "SynTree/Type.h"
#include "SynTree/Visitor.h"

namespace ResolvExpr {
	class FindOpenVars : public Visitor {
	  public:
		FindOpenVars( OpenVarSet &openVars, OpenVarSet &closedVars, AssertionSet &needAssertions, AssertionSet &haveAssertions, bool firstIsOpen );

	  private:
		virtual void visit(PointerType *pointerType);
		virtual void visit(ArrayType *arrayType);
		virtual void visit(FunctionType *functionType);
		virtual void visit(TupleType *tupleType);

		void common_action( Type *type );

		OpenVarSet &openVars, &closedVars;
		AssertionSet &needAssertions, &haveAssertions;
		bool nextIsOpen;
	};

	void findOpenVars( Type *type, OpenVarSet &openVars, OpenVarSet &closedVars, AssertionSet &needAssertions, AssertionSet &haveAssertions, bool firstIsOpen ) {
		FindOpenVars finder( openVars, closedVars, needAssertions, haveAssertions, firstIsOpen );
		type->accept( finder );
	}

	FindOpenVars::FindOpenVars( OpenVarSet &openVars, OpenVarSet &closedVars, AssertionSet &needAssertions, AssertionSet &haveAssertions, bool firstIsOpen )
		: openVars( openVars ), closedVars( closedVars ), needAssertions( needAssertions ), haveAssertions( haveAssertions ), nextIsOpen( firstIsOpen )	{
	}

	void FindOpenVars::common_action( Type *type ) {
		if ( nextIsOpen ) {
			for ( Type::ForallList::const_iterator i = type->get_forall().begin(); i != type->get_forall().end(); ++i ) {
				openVars[ (*i)->get_name() ] = TypeDecl::Data{ (*i) };
				for ( std::list< DeclarationWithType* >::const_iterator assert = (*i)->get_assertions().begin(); assert != (*i)->get_assertions().end(); ++assert ) {
					needAssertions[ *assert ] = false;
				}
///       cloneAll( (*i)->get_assertions(), needAssertions );
///       needAssertions.insert( needAssertions.end(), (*i)->get_assertions().begin(), (*i)->get_assertions().end() );
			}
		} else {
			for ( Type::ForallList::const_iterator i = type->get_forall().begin(); i != type->get_forall().end(); ++i ) {
				closedVars[ (*i)->get_name() ] = TypeDecl::Data{ (*i) };
				for ( std::list< DeclarationWithType* >::const_iterator assert = (*i)->get_assertions().begin(); assert != (*i)->get_assertions().end(); ++assert ) {
					haveAssertions[ *assert ] = false;
				}
///       cloneAll( (*i)->get_assertions(), haveAssertions );
///       haveAssertions.insert( haveAssertions.end(), (*i)->get_assertions().begin(), (*i)->get_assertions().end() );
			} // for
		} // if
///   std::cout << "type is ";
///   type->print( std::cout );
///   std::cout << std::endl << "need is" << std::endl;
///   printAssertionSet( needAssertions, std::cout );
///   std::cout << std::endl << "have is" << std::endl;
///   printAssertionSet( haveAssertions, std::cout );
	}

	void FindOpenVars::visit(PointerType *pointerType) {
		common_action( pointerType );
		Visitor::visit( pointerType );
	}

	void FindOpenVars::visit(ArrayType *arrayType) {
		common_action( arrayType );
		Visitor::visit( arrayType );
	}

	void FindOpenVars::visit(FunctionType *functionType) {
		common_action( functionType );
		nextIsOpen = ! nextIsOpen;
		Visitor::visit( functionType );
		nextIsOpen = ! nextIsOpen;
	}

	void FindOpenVars::visit(TupleType *tupleType) {
		common_action( tupleType );
		Visitor::visit( tupleType );
	}
} // namespace ResolvExpr

// Local Variables: //
// tab-width: 4 //
// mode: c++ //
// compile-command: "make install" //
// End: //
