# Porting notes for new AST #

## Pointer Types ##
* raw pointer `T*` is used for construction, but not storage
* strong pointer `ast::ptr<T>` is used for an ownership relationship
* weak pointer `ast::readonly<T>` is used for an observation relationship

## Visitors ##
* `Visitor` and `Mutator` are combined into a single `ast::Visitor` class
  * Base nodes now override `Node* accept( Visitor& v ) = 0` with, e.g. `Stmt* accept( Visitor& v ) override = 0`
* `PassVisitor` is replaced with `ast::Pass`

## Structural Changes ##
`CodeLocation` has been devolved from `BaseSyntaxNode` to `ast::ParseNode`
* excludes `ast::Type` from carrying location information
* `CodeLocation` is a mandatory constructor field for `ast::ParseNode`
  * all subclass constructors must fill it; by convention, from their first argument

`N->print(std::ostream&)` is a visitor now, port these methods to `ast::Print` class
* **TODO** write this visitor
* **TODO** write `std::ostream& operator<< ( std::ostream& out, const Node* node )` in `Node.hpp` in terms of `ast::Print`
* `Declaration::printShort` should also be integrated

`clone` is private to `Node` now
* still needs to be overriden to return appropriate type
  * e.g. `private: virtual Stmt* clone() const override = 0;`

All leaves of the `Node` inheritance tree are now declared `final`
* e.g. `class CompoundStmt final : public Stmt`
* allows compiler to optimize virtual calls to static calls if given static type

Pulled `FuncSpecifiers` and `StorageClasses` out of `Type` into their own headers
* Made `BFCommon` a `MakeBitfield` macro in its own header
  * added default and field-init constructors to macro

Prefer move semantics for containers passed to node constructors

## Code Style ##

### Files ###
* Headers have a `.hpp` suffix
* Source code has a `.cpp` suffix
* All source has the project-standard leading and trailing comments
* prefer `#pragma once` over `#ifdef` guards
* namespaces that cover entire files don't get indented

### Documentation ###
* class, method, and field comments should use doxygen-style `///` prefix
  * should be included on all classes
  * should be included on any method declaration that doesn't have an obvious behaviour from either naming convention (e.g. constructor, print operator, implement visitor pattern) or an inline implementation
* use explanatory comments with `//` wherever appropriate
  * older comments should be maintained in porting process wherever possible

### Naming ###
* Preserve names from previous AST whenever reasonable, and get team consensus on any changes.
* Strong justification required for private fields
  * No `get_` prefix on getters
* Notable changes:
  * for concision and consistency with subclasses:
    * `Declaration` => `ast::Decl`
	* `DeclarationWithType` => `ast::DeclWithType`  
	* `Expression` => `ast::Expr`
	* `Initializer` => `ast::Init`
    * `Statement` => `ast::Stmt`
  * because they don't really belong to `Type` (and for consistency with `Linkage::Spec`):
    * `Type::StorageClasses` => `ast::Storage::Classes`
	  * `Type::Extern` etc. => `ast::Storage::Extern` etc.
	* `LinkageSpec::Spec` => `ast::Linkage::Spec`
	  * `LinkageSpec::Mangle` etc. => `ast::Linkage::Mangle` etc.
	  * `LinkageSpec::linkageUpdate` => `ast::Linkage::update`
	  * `LinkageSpec::linkageName` => `ast::Linkage::name`
	  * `LinkageSpec::isMangled(Spec)` etc. => `Spec.is_mangled` etc.
	  * `LinkageSpec::Intrinsic` etc. => `ast::Linkage::Intrinsic` etc.

## Specific Nodes ##
`Decl`
* `storageClasses` => `storage`
* `declFromId()` => `fromId()`
  * not 100% sure about the return type here...

`DeclWithType`
* When `SymTab::Validate::Pass2` is rewritten, update comment on `mangleName` with new name of pass

`Expr`
* Merged `inferParams`/`resnSlots` into union, as suggested by comment

`Label`
* `get_statement()` exclusively used for code location, replaced with `CodeLocation` field

`CompoundStmt`
* **TODO** port copy operator
  * Needs to be an almost-shallow clone, where the declarations are cloned only if needed
  * **TODO** port DeclReplacer
* Still a `std::list` for children, rather than `std::vector`
  * allows more-efficient splicing for purposes of later code generation