//
// Cforall Version 1.0.0 Copyright (C) 2015 University of Waterloo
//
// The contents of this file are covered under the licence agreement in the
// file "LICENCE" distributed with Cforall.
//
// Decl.cpp --
//
// Author           : Aaron B. Moss
// Created On       : Thu May 9 10:00:00 2019
// Last Modified By : Aaron B. Moss
// Last Modified On : Thu May 9 10:00:00 2019
// Update Count     : 1
//

#include <unordered_map>

#include "Decl.hpp"

#include "Fwd.hpp"   // for UniqueId
#include "Node.hpp"  // for readonly

namespace ast {
// To canonicalize declarations
static UniqueId lastUniqueId = 0;

using IdMapType = std::unordered_map< UniqueId, readonly<Decl> >;
static IdMapType idMap;

void Decl::fixUniqueId() {
	if ( uniqueId ) return;  // ensure only set once
	uniqueId = ++lastUniqueId;
	idMap[ uniqueId ] = this;
}

readonly<Decl> Decl::fromId( UniqueId id ) {
	IdMapType::const_iterator i = idMap.find( id );
	if ( i != idMap.end() ) return i->second;
	return {};
}
}

// Local Variables: //
// tab-width: 4 //
// mode: c++ //
// compile-command: "make install" //
// End: //
