import java.io.IOException;
import java.io.FileNotFoundException;

public class FileOutputStream implements AutoCloseable {
	public static int throwOnWrite;
	public static int throwOnClose;
	public static int throwOnOpen;

	public static int numWrites;
	public static int numCloses;
	public static int numOpens;

	private String filename;
	private <EX extends Throwable> void doexcept(EX ex, boolean pred) throws EX {
		if (pred) {
			System.out.println("Stream: " + filename + " threw exception: " + ex);
			throw ex;
		}
	}

	public FileOutputStream(String filename) throws FileNotFoundException {
		doexcept(new FileNotFoundException(), throwOnOpen == ++numOpens);
		System.out.println("Opened file: " + filename);
		this.filename = filename;
	}
	public void write(byte[] bytes) throws IOException {
		doexcept(new IOException(), throwOnWrite == ++numWrites);
		System.out.println("wrote message: " + new String(bytes) + " to file: " + filename);
	}
	public void close() throws IOException {
		System.out.println("Closing file: " + filename);
		filename = null;
		doexcept(new IOException(), throwOnClose == ++numCloses);
	}
	protected void finalize() {
		if (filename != null) System.out.println("Finalize closing file: " + filename);
	}
}
