//
// Cforall Version 1.0.0 Copyright (C) 2015 University of Waterloo
//
// The contents of this file are covered under the licence agreement in the
// file "LICENCE" distributed with Cforall.
//
// PtrsAssignable.cc --
//
// Author           : Richard C. Bilson
// Created On       : Sun May 17 11:44:11 2015
// Last Modified By : Peter A. Buhr
// Last Modified On : Wed Mar  2 17:36:05 2016
// Update Count     : 8
//

#include "ResolvExpr/TypeEnvironment.h"  // for EqvClass, TypeEnvironment
#include "SynTree/Type.h"                // for TypeInstType, Type, BasicType
#include "SynTree/Visitor.h"             // for Visitor


namespace ResolvExpr {
	class PtrsAssignable : public Visitor {
	  public:
		PtrsAssignable( Type *dest, const TypeEnvironment &env );

		int get_result() const { return result; }

		virtual void visit( VoidType *voidType );
		virtual void visit( BasicType *basicType );
		virtual void visit( PointerType *pointerType );
		virtual void visit( ArrayType *arrayType );
		virtual void visit( FunctionType *functionType );
		virtual void visit( StructInstType *inst );
		virtual void visit( UnionInstType *inst );
		virtual void visit( EnumInstType *inst );
		virtual void visit( TraitInstType *inst );
		virtual void visit( TypeInstType *inst );
		virtual void visit( TupleType *tupleType );
		virtual void visit( VarArgsType *varArgsType );
		virtual void visit( ZeroType *zeroType );
		virtual void visit( OneType *oneType );
	  private:
		Type *dest;
		int result;
		const TypeEnvironment &env;
	};

	int ptrsAssignable( Type *src, Type *dest, const TypeEnvironment &env ) {
		// std::cerr << "assignable: " << src << " | " << dest << std::endl;
		if ( TypeInstType *destAsTypeInst = dynamic_cast< TypeInstType* >( dest ) ) {
			EqvClass eqvClass;
			if ( env.lookup( destAsTypeInst->get_name(), eqvClass ) ) {
				return ptrsAssignable( src, eqvClass.type, env );
			} // if
		} // if
		if ( dynamic_cast< VoidType* >( dest ) ) {
			// void * = T * for any T is unsafe
			// xxx - this should be safe, but that currently breaks the build
			return -1;
		} else {
			PtrsAssignable ptrs( dest, env );
			src->accept( ptrs );
			return ptrs.get_result();
		} // if
	}

	PtrsAssignable::PtrsAssignable( Type *dest, const TypeEnvironment &env ) : dest( dest ), result( 0 ), env( env ) {}

	void PtrsAssignable::visit( __attribute((unused)) VoidType *voidType ) {
		// T * = void * is disallowed - this is a change from C, where any
		// void * can be assigned or passed to a non-void pointer without a cast.
	}

	void PtrsAssignable::visit( __attribute__((unused)) BasicType *basicType ) {}
	void PtrsAssignable::visit( __attribute__((unused)) PointerType *pointerType ) {}
	void PtrsAssignable::visit( __attribute__((unused)) ArrayType *arrayType ) {}
	void PtrsAssignable::visit( __attribute__((unused)) FunctionType *functionType ) {}

	void PtrsAssignable::visit(  __attribute__((unused)) StructInstType *inst ) {}
	void PtrsAssignable::visit(  __attribute__((unused)) UnionInstType *inst ) {}

	void PtrsAssignable::visit( EnumInstType * ) {
		if ( dynamic_cast< BasicType* >( dest ) ) {
			// int * = E *, etc. is safe. This isn't technically correct, as each
			// enum has one basic type that it is compatible with, an that type can
			// differ from enum to enum. Without replicating GCC's internal logic,
			// there is no way to know which type this particular enum is compatible
			// with, so punt on this for now.
			result = 1;
		}
	}

	void PtrsAssignable::visit(  __attribute__((unused)) TraitInstType *inst ) {}
	void PtrsAssignable::visit( TypeInstType *inst ) {
		EqvClass eqvClass;
		if ( env.lookup( inst->get_name(), eqvClass ) && eqvClass.type ) {
			// T * = S * for any S depends on the type bound to T
			result = ptrsAssignable( eqvClass.type, dest, env );
		} // if
	}

	void PtrsAssignable::visit(  __attribute__((unused)) TupleType *tupleType ) {}
	void PtrsAssignable::visit(  __attribute__((unused)) VarArgsType *varArgsType ) {}
	void PtrsAssignable::visit(  __attribute__((unused)) ZeroType *zeroType ) {}
	void PtrsAssignable::visit(  __attribute__((unused)) OneType *oneType ) {}

} // namespace ResolvExpr

// Local Variables: //
// tab-width: 4 //
// mode: c++ //
// compile-command: "make install" //
// End: //
