#include <errno.h>
#include <fcntl.h>
#include <liburing.h>
#include <stdbool.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>

int main(int argc, char * argv[]) {
	if ( argc != 3 ) {
		printf( "usage\n" );
		exit( EXIT_FAILURE );
	}

	if(argc != 3) {
            printf("usage:   %s FILE TIMES - read FILE from disk TIMES times\n", argv[0]);
            return EXIT_FAILURE;
      }


      int times = atoi( argv[2] );
      if(times <= 0) {
            printf("Invalid number of times %d (from %s).\n", times, argv[2]);
            return EXIT_FAILURE;
      }

      int fd = open(argv[1], 0);
      if(fd < 0) {
            printf("Could not open file %s.\n", argv[1]);
            return EXIT_FAILURE;
      }

	/* prep the array */
      char data[100];
      struct iovec iov = { data, 100 };

	/* init liburing */
	struct io_uring ring;
      io_uring_queue_init(256, &ring, 0);

      /* declare required structs */
	printf("Reading %s(%d) %d times\n", argv[1], fd, times);
	size_t counter = 0;
	for(int i = 0; i < times; i++) {
		/* get an sqe and fill in a READV operation */
	      struct io_uring_sqe * sqe = io_uring_get_sqe(&ring);
		io_uring_prep_readv(sqe, fd, &iov, 1, 0);

		/* tell the kernel we have an sqe ready for consumption */
      	io_uring_submit(&ring);

		/* poll the cq and count how much polling we did */
		while(true) {
			struct io_uring_cqe * cqe = NULL;
			/* wait for the sqe to complete */
			int ret = io_uring_wait_cqe_nr(&ring, &cqe, 0);

			/* read and process cqe event */
			switch(ret) {
			case 0:
				if( cqe->res < 0 ) {
					printf("Completion Error : %s\n", strerror( -cqe->res ));
					return EXIT_FAILURE;
				}
				io_uring_cqe_seen(&ring, cqe);
				goto LOOP;
			case -EAGAIN:
				counter++;
				break;
			default:
				printf("Wait Error : %s\n", strerror( -ret ));
				return EXIT_FAILURE;
			}
		}

		LOOP:;
	}

	printf("%zu\n", counter);

      io_uring_queue_exit(&ring);

      close(fd);
}