#pragma once

//-------------------------------------------------------------------------------------------------------------------------------------------------------------------------
// Deep magic (a.k.a template meta programming) to make the templated visitor work
// Basically the goal is to make 2 previsit_impl
// 1 - Use when a pass implements a valid previsit. This uses overloading which means the any overload of 
//     'pass.previsit( node )' that compiles will be used for that node for that type
//     This requires that this option only compile for passes that actually define an appropriate visit.
//     SFINAE will make sure the compilation errors in this function don't halt the build.
//     See http://en.cppreference.com/w/cpp/language/sfinae for details on SFINAE
// 2 - Since the first implementation might not be specilizable, the second implementation exists and does nothing.
//     This is needed only to eliminate the need for passes to specify any kind of handlers.
//     The second implementation only works because it has a lower priority. This is due to the bogus last parameter.
//     The second implementation takes a long while the first takes an int. Since the caller always passes an literal 0
//     the first implementation takes priority in regards to overloading.
// Mutator functions work along the same principal
//-------------------------------------------------------------------------------------------------------------------------------------------------------------------------
// Visit
template<typename pass_type, typename node_type>
static inline auto previsit_impl( pass_type& pass, node_type * node, __attribute__((unused)) int unused ) ->decltype( pass.previsit( node ), void() ) {
	pass.previsit( node );
}

template<typename pass_type, typename node_type>
static inline void previsit_impl( __attribute__((unused)) pass_type& pass, node_type * node, __attribute__((unused)) long unused ) {}


template<typename pass_type, typename node_type>
static inline auto postvisit_impl( pass_type& pass, node_type * node, __attribute__((unused)) int unused ) ->decltype( pass.postvisit( node ), void() ) {
	pass.postvisit( node );
}

template<typename pass_type, typename node_type>
static inline void postvisit_impl( __attribute__((unused)) pass_type& pass, node_type * node, __attribute__((unused)) long unused ) {}

// Mutate
template<typename pass_type, typename node_type>
static inline auto premutate_impl( pass_type& pass, node_type * node, __attribute__((unused)) int unused ) ->decltype( pass.premutate( node ), void() ) {
	return pass.premutate( node );
}

template<typename pass_type, typename node_type>
static inline void premutate_impl( __attribute__((unused)) pass_type& pass, node_type * node, __attribute__((unused)) long unused ) {}


template<typename return_type, typename pass_type, typename node_type>
static inline auto postmutate_impl( pass_type& pass, node_type * node, __attribute__((unused)) int unused ) ->decltype( pass.postmutate( node ) ) {
	return pass.postmutate( node );
}

template<typename return_type, typename pass_type, typename node_type>
static inline return_type postmutate_impl( __attribute__((unused)) pass_type& pass, node_type * node, __attribute__((unused)) long unused ) { return node; }

// Begin/End scope
template<typename pass_type>
static inline auto begin_scope_impl( pass_type& pass, __attribute__((unused)) int unused ) ->decltype( pass.beginScope(), void() ) {
	pass.beginScope();
}

template<typename pass_type>
static inline void begin_scope_impl( __attribute__((unused)) pass_type& pass, __attribute__((unused)) long unused ) {}


template<typename pass_type>
static inline auto end_scope_impl( pass_type& pass, __attribute__((unused)) int unused ) ->decltype( pass.endScope(), void() ) {
	pass.endScope();
}

template<typename pass_type>
static inline void end_scope_impl( __attribute__((unused)) pass_type& pass, __attribute__((unused)) long unused ) {}