// 
// Cforall Version 1.0.0 Copyright (C) 2016 University of Waterloo
//
// The contents of this file are covered under the licence agreement in the
// file "LICENCE" distributed with Cforall.
//
// alloc.c -- 
// 
// Author           : Peter A. Buhr
// Created On       : Wed Feb  3 07:56:22 2016
// Last Modified By : Peter A. Buhr
// Last Modified On : Mon May 29 11:33:15 2017
// Update Count     : 228
// 

#include <assert>
extern "C" {
#include <malloc.h>										// malloc_usable_size
#include <stdint.h>										// uintptr_t
} // extern
#include <fstream>
#include <stdlib>										// access C malloc, realloc

int * foo( int * p, int c ) { return p; }
int * bar( int * p, int c ) { return p; }
int * baz( int * p, int c ) { return p; }

int main( void ) {
    size_t dim = 10;
    struct S { int x; double y; } * s;
    int * p;

	// allocation, non-array types

    p = (void *)malloc( sizeof(*p) );					// C malloc, type unsafe
	*p = 0xdeadbeef;
	printf( "C   malloc %x\n", *p );
    free( p );

    p = malloc();										// CFA malloc, type safe
	printf( "CFA malloc %d\n", *p );
    free( p );

    p = malloc( '\1' );									// CFA malloc, fill
	printf( "CFA malloc, fill %08x\n", *p );


	// allocation, array types
	printf( "\n" );

    p = calloc( dim, sizeof( *p ) );					// C array calloc, type unsafe
	printf( "C   calloc\n" );
	for ( int i = 0; i < dim; i += 1 ) { printf( "%x ", p[i] ); p[i] = 0Xdeadbeef; }
	printf( "\n" );
    free( p );

    p = calloc( dim );									// CFA array calloc, type safe
	printf( "CFA calloc\n" );
	for ( int i = 0; i < dim; i += 1 ) { printf( "%x ", p[i] ); p[i] = 0Xdeadbeef; }
	printf( "\n" );
    free( p );

    p = amalloc( dim );									// CFA array malloc, type safe
	printf( "CFA array malloc\n" );
	for ( int i = 0; i < dim; i += 1 ) { printf( "%x ", p[i] ); p[i] = 0Xdeadbeef; }
	printf( "\n" );
    free( p );

    p = amalloc( 2 * dim, '\1' );						// CFA array malloc, fill
	printf( "CFA array malloc\n" );
	for ( int i = 0; i < 2 * dim; i += 1 ) { printf( "%x ", p[i] ); p[i] = 0Xdeadbeef; }
	printf( "\n" );
	// do not free


	// resize, non-array types
	printf( "\n" );

    p = (void *)realloc( p, dim * sizeof(*p) );			// CFA realloc
	printf( "C   realloc\n" );
	for ( int i = 0; i < dim; i += 1 ) { printf( "%x ", p[i] ); p[i] = 0Xdeadbeef; }
	printf( "\n" );

    p = realloc( p, 2 * dim * sizeof(*p) );				// CFA realloc
	printf( "CFA realloc\n" );
	for ( int i = 0; i < 2 * dim; i += 1 ) { printf( "%x ", p[i] ); p[i] = 0Xdeadbeef; }
	printf( "\n" );

    p = realloc( p, dim * sizeof(*p), '\1' );			// CFA realloc
	printf( "CFA realloc\n" );
	for ( int i = 0; i < dim; i += 1 ) { printf( "%x ", p[i] ); p[i] = 0Xdeadbeef; }
	printf( "\n" );

    p = malloc( p, dim * sizeof(*p) );					// CFA malloc
	printf( "CFA resize malloc\n" );
	for ( int i = 0; i < dim; i += 1 ) { printf( "%x ", p[i] ); p[i] = 0Xdeadbeef; }
	printf( "\n" );

    p = malloc( p, 2 * dim * sizeof(*p), '\1' );		// CFA malloc, fill
	printf( "CFA resize malloc, fill\n" );
	for ( int i = 0; i < 2 * dim; i += 1 ) { printf( "%x ", p[i] ); p[i] = 0Xdeadbeef; }
	printf( "\n" );

    p = malloc( p, dim * sizeof(*p), '\1' );			// CFA malloc, fill
	printf( "CFA resize malloc, fill\n" );
	for ( int i = 0; i < dim; i += 1 ) { printf( "%x ", p[i] ); p[i] = 0Xdeadbeef; }
	printf( "\n" );
	// do not free


	// resize, array types
	printf( "\n" );

    p = amalloc( p, 2 * dim );							// CFA array malloc
	printf( "CFA resize array malloc\n" );
	for ( int i = 0; i < 2 * dim; i += 1 ) { printf( "%x ", p[i] ); p[i] = 0Xdeadbeef; }
	printf( "\n" );

    p = amalloc( p, dim );								// CFA array malloc
	printf( "CFA resize array malloc\n" );
	for ( int i = 0; i < dim; i += 1 ) { printf( "%x ", p[i] ); p[i] = 0Xdeadbeef; }
	printf( "\n" );

    p = amalloc( p, 2 * dim, '\1' );					// CFA array malloc, fill
	printf( "CFA resize array malloc, fill\n" );
	for ( int i = 0; i < 2 * dim; i += 1 ) { printf( "%x ", p[i] ); p[i] = 0Xdeadbeef; }
	printf( "\n" );

    p = amalloc( p, dim, '\1' );						// CFA array malloc, fill
	printf( "CFA resize array malloc, fill\n" );
	for ( int i = 0; i < dim; i += 1 ) { printf( "%x ", p[i] ); p[i] = 0Xdeadbeef; }
	free( p );
	printf( "\n" );

    struct Struct { int x; double y; };
    Struct st, st1, sta[dim], sta1[dim], * stp;


	// alignment, non-array types
	printf( "\n" );

	enum { Alignment = 128 };
    stp = aligned_alloc( Alignment );					// CFA aligned_alloc
	*stp = (Struct){ 42, 42.5 };
	assert( (uintptr_t)stp % Alignment == 0 );
	printf( "CFA aligned_alloc %d %g\n", stp->x, stp->y );
    free( stp );

    stp = memalign( Alignment );						// CFA memalign
	*stp = (Struct){ 42, 42.5 };
	assert( (uintptr_t)stp % Alignment == 0 );
	printf( "CFA memalign %d %g\n", stp->x, stp->y );
    free( stp );

    posix_memalign( &stp, Alignment );					// CFA posix_memalign
	*stp = (Struct){ 42, 42.5 };
	assert( (uintptr_t)stp % Alignment == 0 );
	printf( "CFA posix_memalign %d %g\n", stp->x, stp->y );
    free( stp );

    stp = memalign( Alignment, '\1' );					// CFA memalign, fill
	assert( (uintptr_t)stp % Alignment == 0 );
	printf( "CFA memalign fill %d %g\n", stp->x, stp->y );
    free( stp );


	// alignment, array types
	printf( "\n" );

    stp = amemalign( Alignment, 2 * dim );				// CFA array memalign
	assert( (uintptr_t)stp % Alignment == 0 );
	printf( "CFA memalign array\n" );
	for ( int i = 0; i < 2 * dim; i += 1 ) { printf( "%x %g, ", stp[i].x, stp[i].y ); stp[i].x = 0Xdeadbeef, stp[i].y = -17.2; }
	printf( "\n" );
    free( stp );

    stp = amemalign( Alignment, dim, '\1' );			// CFA array memalign, fill
	assert( (uintptr_t)stp % Alignment == 0 );
	printf( "CFA memalign array\n" );
	for ( int i = 0; i < dim; i += 1 ) { printf( "%x %g, ", stp[i].x, stp[i].y ); stp[i].x = 0Xdeadbeef, stp[i].y = -17.2; }
	printf( "\n" );
    free( stp );


	// data, non-array types
	printf( "\n" );

    stp = memset( &st, '\xff' );						// CFA memset, type safe
	printf( "CFA memset %x %g\n", st.x, st.y );
    stp = memcpy( &st1, &st );							// CFA memcpy, type safe
	printf( "CFA memcpy %x %g\n", st1.x, st1.y );


	// data, array types
	printf( "\n" );

    stp = amemset( sta, dim, '\xff' );					// CFA array memset, type safe
	printf( "CFA array memset\n" );
	for ( int i = 0; i < dim; i += 1 ) { printf( "%x %g, ", sta[i].x, sta[i].y ); sta[i].x = 0Xdeadbeef, sta[i].y = -17.2; }
	printf( "\n" );

    stp = amemcpy( sta1, sta, dim );					// CFA array memcpy, type safe
	printf( "CFA memcpy\n" );
	for ( int i = 0; i < dim; i += 1 ) { printf( "%x %g, ", sta1[i].x, sta1[i].y ); sta1[i].x = 0Xdeadbeef, sta1[i].y = -17.2; }
	printf( "\n" );

    float * fp = malloc() + 1;
    printf( "pointer arithmetic %d\n", fp == fp - 1 );
    free( fp - 1 );

    p = foo( bar( baz( malloc(), 0 ), 0 ), 0 );
	*p = 0xdeadbeef;
	printf( "CFA deep malloc %x\n", *p );
    free( p );

	stp = malloc();
	printf( "\nSHOULD FAIL\n" );
    p = malloc( stp, dim * sizeof(*stp) );
    p = memset( stp, 10 );
    p = memcpy( &st1, &st );
} // main

// Local Variables: //
// tab-width: 4 //
// compile-command: "cfa alloc.c" //
// End: //
