//
// Cforall Version 1.0.0 Copyright (C) 2015 University of Waterloo
//
// The contents of this file are covered under the licence agreement in the
// file "LICENCE" distributed with Cforall.
//
// TypedefTable.cc -- 
//
// Author           : Peter A. Buhr
// Created On       : Sat May 16 15:20:13 2015
// Last Modified By : Peter A. Buhr
// Last Modified On : Fri Jun  1 16:54:18 2018
// Update Count     : 155
//


#include "TypedefTable.h"
#include <cassert>										// for assert

#if 0
#include <iostream>
#define debugPrint( code ) code
#else
#define debugPrint( code )
#endif

using namespace std;									// string, iostream

TypedefTable::~TypedefTable() {
	if ( ! SemanticErrorThrow && kindTable.currentScope() != 0 ) {
		std::cerr << "scope failure " << kindTable.currentScope() << endl;
	} // if
} // TypedefTable::~TypedefTable

bool TypedefTable::exists( const string & identifier ) {
	return kindTable.find( identifier ) != kindTable.end();
} // TypedefTable::exists

int TypedefTable::isKind( const string & identifier ) const {
	KindTable::const_iterator posn = kindTable.find( identifier );
	// Name lookup defaults to identifier, and then the identifier's kind is set by the parser.
	if ( posn == kindTable.end() ) return IDENTIFIER;
	return posn->second;
} // TypedefTable::isKind

void TypedefTable::changeKind( const string & identifier, int kind ) {
	KindTable::iterator posn = kindTable.find( identifier );
	if ( posn != kindTable.end() ) posn->second = kind;	// exists => update
} // TypedefTable::changeKind

// SKULLDUGGERY: Generate a typedef for the aggregate name so the aggregate does not have to be qualified by
// "struct". Only generate the typedef, if the name is not in use. The typedef is implicitly (silently) removed if the
// name is explicitly used.
void TypedefTable::makeTypedef( const string & name ) {
	if ( ! typedefTable.exists( name ) ) {
		typedefTable.addToEnclosingScope( name, TYPEDEFname, "MTD" );
	} // if
} // TypedefTable::makeTypedef

void TypedefTable::addToScope( const std::string & identifier, int kind, const char * locn __attribute__((unused)) ) {
	auto scope = kindTable.currentScope();
	debugPrint( cerr << "Adding at " << locn << " " << identifier << " as kind " << kind << " scope " << scope << endl );
	auto ret = kindTable.insertAt( scope, identifier, kind );
	if ( ! ret.second ) ret.first->second = kind;		// exists => update
} // TypedefTable::addToScope

void TypedefTable::addToEnclosingScope( const std::string & identifier, int kind, const char * locn __attribute__((unused)) ) {
	assert( kindTable.currentScope() >= 1 );
	auto scope = kindTable.currentScope() - 1;
	debugPrint( cerr << "Adding+1 at " << locn << " " << identifier << " as kind " << kind << " scope " << scope << endl );
	auto ret = kindTable.insertAt( scope, identifier, kind );
	if ( ! ret.second ) ret.first->second = kind;		// exists => update
} // TypedefTable::addToEnclosingScope

void TypedefTable::enterScope() {
	kindTable.beginScope();
	debugPrint( cerr << "Entering scope " << kindTable.currentScope() << endl );
	debugPrint( print() );
} // TypedefTable::enterScope

void TypedefTable::leaveScope() {
	debugPrint( cerr << "Leaving scope " << kindTable.currentScope() << endl );
	debugPrint( print() );
	kindTable.endScope();
} // TypedefTable::leaveScope

void TypedefTable::print( void ) const {
	KindTable::size_type scope = kindTable.currentScope();
	debugPrint( cerr << "[" << scope << "]" );
	for ( KindTable::const_iterator i = kindTable.begin(); i != kindTable.end(); i++ ) {
		while ( i.get_level() != scope ) {
			--scope;
			debugPrint( cerr << endl << "[" << scope << "]" );
		} // while
		debugPrint( cerr << " " << (*i).first << ":" << (*i).second );
	} // for
	while ( scope > 0 ) {
		--scope;
		debugPrint( cerr << endl << "[" << scope << "]" );
	}
	debugPrint( cerr << endl );
}

// Local Variables: //
// tab-width: 4 //
// mode: c++ //
// compile-command: "make install" //
// End: //
