# Read thesis-append-pbv.csv
# Output for string-graph-peq-sharing.dat

# Project details
# Filter operation=peq
# Split "series" goups of sut; only those in the "pretty" list
# Assert one row per string-length
# output:
# string-len op-duration
# in chunks, each headed by pertty(sut)

import pandas as pd
import numpy as np
import os
import sys

sys.path.insert(0, os.path.dirname(__file__))
from common import *

prettyFieldNames = {
    "cfa-ll-share-fresh": "{/Helvetica=15 C{/Symbol \\42} +=} share fresh",
    "cfa-ll-share-reuse": "{/Helvetica=15 C{/Symbol \\42} +=} share reuse",
    "stl-na-na-fresh": "STL {/Helvetica=15 +=} fresh",
    "stl-na-na-reuse": "STL {/Helvetica=15 +=} reuse",
}

timings = loadParseTimingData('result-append-pbv.csv')


# Filter operation=peq, corpus=100-*-1

timings = timings.groupby('operation').get_group('peq')
timings = timings.groupby('corpus-nstrs').get_group(100)
timings = timings.groupby('corpus-runid').get_group(1)


# Emit in groups

groupedSut = timings.groupby('sut')

for sut, sgroup in groupedSut:

    if sut in prettyFieldNames:

        sgroup_sorted = sgroup.sort_values(by='corpus-meanlen')

        print('"{header}"'.format(header=prettyFieldNames[sut]))
        text = sgroup_sorted[['corpus-meanlen', 'op-duration-ns']].to_csv(header=False, index=False, sep='\t')
        print(text)
        print()
