set terminal pdf color enhanced size 6.0in,4.0in font "Times,17"
#set terminal postscript portrait enhanced size 7.5, 10. color solid 9.5;
#set terminal wxt size 950,1250

INDIR="build"
OUTDIR="build"

SCALE=1024

# common to all
set macros
set output OUTDIR."/plot-string-allocn.pdf"
set multiplot layout 1, 3 ;
set key outside top center horizontal
set grid

# common to only first two graphs
set logscale x 2
#set mxtics 3                      # 3 steps within each doubling (e.g. 3 steps of of 32 between 32 and 128 => tick on 32s in there)
set xlabel "Heap Used (B)"
set logscale y 10

#
# CFA multisize
#

set ylabel "Duration (ns)" offset 2,0
set yrange[35:125]
set ytics add (40, 50, 60, 70, 80, 90, 110, 120)

set xrange[32:4096]
set xtics rotate by -90
set xtics ("" 32, "64 k" 64, "" 128, "256 k" 256, "" 512, "1 M" 1024, "" 2048, "4 M" 4096)

# First each curve, then each default-expansion point
plot INDIR."/plot-string-allocn.dat" \
	   i 0 using ($3/SCALE):2 title columnheader(1) with linespoints lt rgb "blue"    pt  2   ps 1 lw 1, \
	'' i 1 using ($3/SCALE):2 title columnheader(1) with linespoints lt rgb "red"     pt  3   ps 1 lw 1, \
	'' i 2 using ($3/SCALE):2 title columnheader(1) with linespoints lt rgb "brown"   pt  8   ps 1 lw 1, \
	'' i 3 using ($3/SCALE):2 title columnheader(1) with linespoints lt rgb "black"   pt  10  ps 1 lw 1, \
	'' i 4 using ($3/SCALE):2 title columnheader(1) with linespoints lt rgb "magenta" pt  12  ps 1 lw 1, \
	'' i 0 using ( ($4 == 1) ? ($3/SCALE) : 1/0 ):2 notitle with points lt rgb "blue"    pt  66 ps 2, \
	'' i 1 using ( ($4 == 1) ? ($3/SCALE) : 1/0 ):2 notitle with points lt rgb "red"     pt  66 ps 2, \
	'' i 2 using ( ($4 == 1) ? ($3/SCALE) : 1/0 ):2 notitle with points lt rgb "brown"   pt  66 ps 2, \
	'' i 3 using ( ($4 == 1) ? ($3/SCALE) : 1/0 ):2 notitle with points lt rgb "black"   pt  66 ps 2, \
	'' i 4 using ( ($4 == 1) ? ($3/SCALE) : 1/0 ):2 notitle with points lt rgb "magenta" pt  66 ps 2

unset ylabel

unset xtics
unset ytics
unset yrange
unset xrange


#
# STL comparison
#


set yrange[40:85]
set ytics add (40, 45, 50, 55, 60, 65, 70, 75, 80, 85)
set mytics 90                     # 90 steps within each decade (e.g. 90 steps of of 1 between 10 and 100 => tick on 1s in there)

set xrange[64:4096]
set xtics rotate by -90
set xtics ("64 k" 64, "128 k" 128, "256 k" 256, "512 k" 512, "1 M" 1024, "2 M" 2048, "4 M" 4096)

# skullduggeries:
# hardcoding chunk index and assuming data in the chunk (by hardcoding only the stl series title)
# series order is meaningless but important: achieves z-order readability and legend order acceptability

plot INDIR."/plot-string-allocn.dat" \
	   i 8 using                          ($3/SCALE)        :2 title "tradeoff"      with lines       lt rgb "#77000000"  dt (2,2)       lw 8, \
	'' i 1 using                          ($3/SCALE)        :2 title columnheader(1) with linespoints lt rgb "red"        pt  3    ps 1  lw 1, \
	'' i 6 using ( (strcol(4) eq "cfa") ? ($3/SCALE) : 1/0 ):2 notitle               with points      lt rgb "red"        pt 66    ps 2,       \
	'' i 6 using                          ($3/SCALE)        :2 notitle               with lines       lt rgb "#77000000"  dt (2,2)       lw 8, \
	'' i 6 using ( (strcol(4) eq "stl") ? ($3/SCALE) : 1/0 ):2 title "stl, len=50"   with points      lt rgb "red"        pt 5     ps 1,       \
	'' i 3 using                          ($3/SCALE)        :2 title columnheader(1) with linespoints lt rgb "black"      pt  10   ps 1  lw 1, \
	'' i 8 using ( (strcol(4) eq "stl") ? ($3/SCALE) : 1/0 ):2 title "stl, len=200"  with points      lt rgb "black"      pt 5     ps 1,       \
	'' i 8 using ( (strcol(4) eq "cfa") ? ($3/SCALE) : 1/0 ):2 notitle               with points      lt rgb "black"      pt 66    ps 2


unset mytics
unset ytics
unset yrange
unset xrange



# common to first two graphs
unset logscale
unset xlabel
unset mxtics

#
# Attribution
#

set style data histogram
set ytics auto
set style histogram clustered gap 1 rowstacked
set style fill solid border -1
set boxwidth 0.8
set xtics rotate by -45

plot for [col=3:8] \
    INDIR.'/plot-string-allocn-attrib.dat' using col:xticlabels(stringcolumn(2).", len=".stringcolumn(1)) index 0 title columnheader(col)
