//
// Cforall Version 1.0.0 Copyright (C) 2015 University of Waterloo
//
// The contents of this file are covered under the licence agreement in the
// file "LICENCE" distributed with Cforall.
//
// PtrsAssignable.cc -- 
//
// Author           : Richard C. Bilson
// Created On       : Sun May 17 11:44:11 2015
// Last Modified By : Peter A. Buhr
// Last Modified On : Wed Mar  2 17:36:05 2016
// Update Count     : 8
//

#include "typeops.h"
#include "SynTree/Type.h"
#include "SynTree/Declaration.h"
#include "SynTree/Visitor.h"


namespace ResolvExpr {
	class PtrsAssignable : public Visitor {
	  public:
		PtrsAssignable( Type *dest, const TypeEnvironment &env );

		int get_result() const { return result; }

		virtual void visit( VoidType *voidType );
		virtual void visit( BasicType *basicType );
		virtual void visit( PointerType *pointerType );
		virtual void visit( ArrayType *arrayType );
		virtual void visit( FunctionType *functionType );
		virtual void visit( StructInstType *inst );
		virtual void visit( UnionInstType *inst );
		virtual void visit( EnumInstType *inst );
		virtual void visit( TraitInstType *inst );
		virtual void visit( TypeInstType *inst );
		virtual void visit( TupleType *tupleType );
		virtual void visit( VarArgsType *varArgsType );
		virtual void visit( ZeroType *zeroType );
		virtual void visit( OneType *oneType );
	  private:
		Type *dest;
		int result;
		const TypeEnvironment &env;
	};

	int ptrsAssignable( Type *src, Type *dest, const TypeEnvironment &env ) {
		if ( TypeInstType *destAsTypeInst = dynamic_cast< TypeInstType* >( dest ) ) {
			EqvClass eqvClass;
			if ( env.lookup( destAsTypeInst->get_name(), eqvClass ) ) {
				return ptrsAssignable( src, eqvClass.type, env );
			} // if
		} // if
		if ( dynamic_cast< VoidType* >( dest ) ) {
			return 1;
		} else {
			PtrsAssignable ptrs( dest, env );
			src->accept( ptrs );
			return ptrs.get_result();
		} // if
	}

	PtrsAssignable::PtrsAssignable( Type *dest, const TypeEnvironment &env ) : dest( dest ), result( 0 ), env( env ) {
	}

	void PtrsAssignable::visit( VoidType *voidType ) {
		if ( dynamic_cast< FunctionType* >( dest ) ) {
			result = 0;
		} else {
			result = -1;
		} // if
	}

	void PtrsAssignable::visit( BasicType *basicType ) {
	}

	void PtrsAssignable::visit( PointerType *pointerType ) {
	}

	void PtrsAssignable::visit( ArrayType *arrayType ) {
	}

	void PtrsAssignable::visit( FunctionType *functionType ) {
		result = -1;
	}

	void PtrsAssignable::visit( StructInstType *inst ) {
		// I don't think we should be doing anything here, but I'm willing to admit that I might be wrong
	}

	void PtrsAssignable::visit( UnionInstType *inst ) {
		// I don't think we should be doing anything here, but I'm willing to admit that I might be wrong
	}

	void PtrsAssignable::visit( EnumInstType *inst ) {
		if ( dynamic_cast< EnumInstType* >( inst ) ) {
			result = 1;
		} else if ( BasicType *bt = dynamic_cast< BasicType* >( inst ) ) {
			result = bt->get_kind() == BasicType::SignedInt;
		}
	}

	void PtrsAssignable::visit( TraitInstType *inst ) {
		// I definitely don't think we should be doing anything here
	}

	void PtrsAssignable::visit( TypeInstType *inst ) {
		EqvClass eqvClass;
		if ( env.lookup( inst->get_name(), eqvClass ) && eqvClass.type ) {
			result = ptrsAssignable( eqvClass.type, dest, env );
		} else {
			result = 0;
		} // if
	}

	void PtrsAssignable::visit( TupleType *tupleType ) {
///  // This code doesn't belong here, but it might be useful somewhere else
///   if ( TupleType *destAsTuple = dynamic_cast< TupleType* >( dest ) ) {
///     int ret = 0;
///     std::list< Type* >::const_iterator srcIt = tupleType->get_types().begin();
///     std::list< Type* >::const_iterator destIt = destAsTuple->get_types().begin();
///     while ( srcIt != tupleType->get_types().end() && destIt != destAsTuple->get_types().end() ) {
///       int assignResult = ptrsAssignable( *srcIt++, *destIt++ );
///       if ( assignResult == 0 ) {
///         result = assignResult;
///         return;
///       } else if ( assignResult < 0 ) {
///         ret = -1;
///       } else if ( ret > 0 ) {
///         ret += assignResult;
///       }
///     }
///     if ( srcIt == tupleType->get_types().end() && destIt == destAsTuple->get_types().end() ) {
///       result = ret;
///     } else {
///       result = 0;
///     }
///   }
	}

	void PtrsAssignable::visit( VarArgsType *varArgsType ) {
	}

	void PtrsAssignable::visit( ZeroType *zeroType ) {
	}
	
	void PtrsAssignable::visit( OneType *oneType ) {
	}
	
} // namespace ResolvExpr

// Local Variables: //
// tab-width: 4 //
// mode: c++ //
// compile-command: "make install" //
// End: //
