#!/usr/bin/python

import sys
import numpy

if len(sys.argv) != 2 :
	sys.exit("Expected file name as only argument")

try:
	with open(sys.argv[1]) as f:
		content = f.readlines()
		content = [x.strip() for x in content]
		content = [int(x) for x in content]
		content.remove(max(content))
		content.remove(min(content))
		print "median {0} avg {1} stddev {2}".format( numpy.median(content), numpy.mean(content), numpy.std(content) )


except IOError as e:
	sys.exit(e.strerror)