// 
// Cforall Version 1.0.0 Copyright (C) 2016 University of Waterloo
//
// The contents of this file are covered under the licence agreement in the
// file "LICENCE" distributed with Cforall.
// 
// limits.c -- 
// 
// Author           : Peter A. Buhr
// Created On       : Wed Apr  6 18:06:52 2016
// Last Modified By : Peter A. Buhr
// Last Modified On : Thu Apr  7 17:18:45 2016
// Update Count     : 11
// 

#include "limits"

// Integral Constants

const short int MIN = -32768;
const int MIN = -2147483648;
const long int MIN = -9223372036854775807L - 1L;
const long long int MIN = -9223372036854775807LL - 1LL;

const short int MAX = 32767;
const unsigned short int MAX = 65535;
const int MAX = 2147483647;
const unsigned int MAX = 4294967295_U;
const long int MAX = 9223372036854775807_L;
const unsigned long int MAX = 4294967295_U;
const long long int MAX = 9223372036854775807_LL;
const unsigned long long int MAX = 18446744073709551615_ULL;

// Floating-Point Constants

const float PI = 3.141592_F;							// pi
const float PI_2 = 1.570796_F;							// pi / 2
const float PI_4 = 0.7853981_F;							// pi / 4
const float _1_PI = 0.3183098_F;						// 1 / pi
const float _2_PI = 0.6366197_F;						// 2 / pi
const float _2_SQRT_PI = 1.128379_F;					// 2 / sqrt(pi)

const double PI = 3.14159265358979323846_D;				// pi
const double PI_2 = 1.57079632679489661923_D;			// pi / 2
const double PI_4 = 0.78539816339744830962_D;			// pi / 4
const double _1_PI = 0.31830988618379067154_D;			// 1 / pi
const double _2_PI = 0.63661977236758134308_D;			// 2 / pi
const double _2_SQRT_PI = 1.12837916709551257390_D;		// 2 / sqrt(pi)

const long double PI = 3.1415926535897932384626433832795029_DL; // pi
const long double PI_2 = 1.5707963267948966192313216916397514_DL; // pi / 2
const long double PI_4 = 0.7853981633974483096156608458198757_DL; // pi / 4
const long double _1_PI = 0.3183098861837906715377675267450287_DL; // 1 / pi
const long double _2_PI = 0.6366197723675813430755350534900574_DL; // 2 / pi
const long double _2_SQRT_PI = 1.1283791670955125738961589031215452_DL; // 2 / sqrt(pi)

const _Complex PI = 3.14159265358979323846_D+0.0_iD;	// pi
const _Complex PI_2 = 1.57079632679489661923_D+0.0_iD;	// pi / 2
const _Complex PI_4 = 0.78539816339744830962_D+0.0_iD;	// pi / 4
const _Complex _1_PI = 0.31830988618379067154_D+0.0_iD;	// 1 / pi
const _Complex _2_PI = 0.63661977236758134308_D+0.0_iD;	// 2 / pi
const _Complex _2_SQRT_PI = 1.12837916709551257390_D+0.0_iD; // 2 / sqrt(pi)

const long _Complex PI = 3.1415926535897932384626433832795029_L+0.0iL; // pi
const long _Complex PI_2 = 1.5707963267948966192313216916397514_L+0.0iL; // pi / 2
const long _Complex PI_4 = 0.7853981633974483096156608458198757_L+0.0iL; // pi / 4
const long _Complex _1_PI = 0.3183098861837906715377675267450287_L+0.0iL; // 1 / pi
const long _Complex _2_PI = 0.6366197723675813430755350534900574_L+0.0iL; // 2 / pi
const long _Complex _2_SQRT_PI = 1.1283791670955125738961589031215452_L+0.0iL; // 2 / sqrt(pi)

const float E = 2.718281;								// e
const float LOG2_E = 1.442695;							// log_2(e)
const float LOG10_E = 0.4342944;						// log_10(e)
const float LN_2 = 0.6931471;							// log_e(2)
const float LN_10 = 2.302585;							// log_e(10)
const float SQRT_2 = 1.414213;							// sqrt(2)
const float _1_SQRT_2 = 0.7071067;						// 1 / sqrt(2)

const double E = 2.7182818284590452354_D;				// e
const double LOG2_E = 1.4426950408889634074_D;			// log_2(e)
const double LOG10_E = 0.43429448190325182765_D;		// log_10(e)
const double LN_2 = 0.69314718055994530942_D;			// log_e(2)
const double LN_10 = 2.30258509299404568402_D;			// log_e(10)
const double SQRT_2 = 1.41421356237309504880_D;			// sqrt(2)
const double _1_SQRT_2 = 0.70710678118654752440_D;		// 1 / sqrt(2)

const long double E = 2.7182818284590452353602874713526625_DL; // e
const long double LOG2_E = 1.4426950408889634073599246810018921_DL; // log_2(e)
const long double LOG10_E = 0.4342944819032518276511289189166051_DL; // log_10(e)
const long double LN_2 = 0.6931471805599453094172321214581766_DL; // log_e(2)
const long double LN_10 = 2.3025850929940456840179914546843642_DL; // log_e(10)
const long double SQRT_2 = 1.4142135623730950488016887242096981_DL; // sqrt(2)
const long double _1_SQRT_2 = 0.7071067811865475244008443621048490_DL; // 1/sqrt(2)

const _Complex E = 2.7182818284590452354_D+0.0_iD;		// e
const _Complex LOG2_E = 1.4426950408889634074_D+0.0_iD;	// log_2(e)
const _Complex LOG10_E = 0.43429448190325182765_D+0.0_iD; // log_10(e)
const _Complex LN_2 = 0.69314718055994530942_D+0.0_iD;	// log_e(2)
const _Complex LN_10 = 2.30258509299404568402_D+0.0_iD;	// log_e(10)
const _Complex SQRT_2 = 1.41421356237309504880_D+0.0_iD; // sqrt(2)
const _Complex _1_SQRT_2 = 0.70710678118654752440_D+0.0_iD; // 1 / sqrt(2)

const long _Complex E = 2.7182818284590452353602874713526625_L+0.0_iL; // e
const long _Complex LOG2_E = 1.4426950408889634073599246810018921_L+0.0_iL; // log_2(e)
const long _Complex LOG10_E = 0.4342944819032518276511289189166051_L+0.0_iL; // log_10(e)
const long _Complex LN_2 = 0.6931471805599453094172321214581766_L+0.0_iL; // log_e(2)
const long _Complex LN_10 = 2.3025850929940456840179914546843642_L+0.0_iL; // log_e(10)
const long _Complex SQRT_2 = 1.4142135623730950488016887242096981_L+0.0_iL; // sqrt(2)
const long _Complex _1_SQRT_2 = 0.7071067811865475244008443621048490_L+0.0_iL; // 1 / sqrt(2)

// Local Variables: //
// mode: c //
// tab-width: 4 //
// End: //
