//                               -*- Mode: C -*- 
// 
// Cforall Version 1.0.0 Copyright (C) 2016 University of Waterloo
//
// The contents of this file are covered under the licence agreement in the
// file "LICENCE" distributed with Cforall.
// 
// rational.c -- 
// 
// Author           : Peter A. Buhr
// Created On       : Mon Mar 28 08:43:12 2016
// Last Modified By : Peter A. Buhr
// Last Modified On : Thu Apr  7 17:25:44 2016
// Update Count     : 20
// 

#include <limits>
#include <rational>
#include <fstream>

int main() {
	Rational a, b, c;
	sout | "constructor" | endl;
	a = rational( 3 );
	b = rational( 4 );
	c = rational();
	sout | a | b | c | endl;
	a = rational( 4, 8 );
	b = rational( 5, 7 );
	sout | a | b | endl;
	a = rational( -2, -3 );
	b = rational( 3, -2 );
	sout | a | b | endl;
	a = rational( -2, 3 );
	b = rational( 3, 2 );
	sout | a | b | endl;

	sout | "logical" | endl;
	a = rational( -2 );
	b = rational( -3, 2 );
	sout | a | b | endl;
	sout | a == 1 | endl;
	sout | a != b | endl;
	sout | a <  b | endl;
	sout | a <= b | endl;
	sout | a >  b | endl;
	sout | a >= b | endl;

	sout | "arithmetic" | endl;
	sout | a | b | endl;
	sout | a + b | endl;
	sout | a - b | endl;
	sout | a * b | endl;
	sout | a / b | endl;

	sout | "conversion" | endl;
	a = rational( 3, 4 );
	sout | widen( a ) | endl;
	a = rational( 1, 7 );
	sout | widen( a ) | endl;
	a = rational( 355, 113 );
	sout | widen( a ) | endl;
	sout | narrow( 0.75, 4 ) | endl;
	sout | narrow( 0.14285714285714, 16 ) | endl;
	sout | narrow( 3.14159265358979, 256 ) | endl;

	Rational x, y;
	x = rational( 1, 2 );
	y = rational( 2 );
	sout | x - y | endl;
	sout | x > y | endl;
	sout | x | numerator( x, 2 ) | x | endl;
	sout | y | denominator( y, -2 ) | y | endl;

	Rational z;
	z = rational( 0, 5 );
	sout | z | endl;

	sout | x | numerator( x, 0 ) | x | endl;

	x = rational( 1, MAX ) + rational( 1, MAX );
	sout | x | endl;
	x = rational( 3, MAX ) + rational( 2, MAX );
	sout | x | endl;

	sin | &a | &b;
	sout | a | b | endl;
} // main

// Local Variables: //
// tab-width: 4 //
// compile-command: "cfa rational.c" //
// End: //
