## "Zero Cost" Preemption in for Cforall ##

Similar to "Zero Cost" exceptions, this is a proposal to support preemption with little to no runtime cost for the book-keeping. (Other than having exceptions).

Preemption stops users threads at random locations and forces a context switch using a signal handler. Since this is not safe and/or does not make sense in many contexts, the runtime needs a system to disable interrupts for certain regions of codes.

Currently, Cforall uses _[kernel] thread-local storage_(TLS) to handle this, setting a flag to false when preemption should be disabled. This works on x86/x64 but only with a specific TLS model, and does not work with ARM. The problem is that if the loading of the TLS variable is not done in a single instruction, it allows a race condition, where user-threads could disable preemption for the wrong processor, i.e., be moved to a different processor and update the previous processor.

The fix being worked on is to protect the specific TLS variable with a special function.

## The Proposal ##
A better approach, would be to re-use the Exception Handling Data structure to identify regions of code that do not allow preemption. These regions of code would be marked using the same mechanism which marks stack unwinding requirements.

When the signal handler is called, it would search the stack similarly to how the stack is searched when an exception is thrown and do the context switch or not based on the result.

This is an optimization, since signal handlers for preemption are already rare and costly but enabling/disabling interrupts is very common (1000x more common). Using the "Zero-Cost" exception mechanism, enabling/disabling interrupts should be free at runtime and the rare signal/handler become more expensive.