//
// Cforall Version 1.0.0 Copyright (C) 2016 University of Waterloo
//
// The contents of this file are covered under the licence agreement in the
// file "LICENCE" distributed with Cforall.
//
// exception.h -- Builtins for exception handling.
//
// Author           : Andrew Beach
// Created On       : Mon Jun 26 15:11:00 2017
// Last Modified By : Andrew Beach
// Last Modified On : Fri Mar 27 10:16:00 2020
// Update Count     : 9
//

#pragma once


#ifdef __cforall
extern "C" {
#endif

struct __cfaehm_base_exception_t;
typedef struct __cfaehm_base_exception_t exception_t;
struct __cfaehm_base_exception_t_vtable {
	const struct __cfaehm_base_exception_t_vtable * parent;
	size_t size;
	void (*copy)(struct __cfaehm_base_exception_t *this,
	             struct __cfaehm_base_exception_t * other);
	void (*free)(struct __cfaehm_base_exception_t *this);
	const char * (*msg)(struct __cfaehm_base_exception_t *this);
};
struct __cfaehm_base_exception_t {
	struct __cfaehm_base_exception_t_vtable const * virtual_table;
};
extern struct __cfaehm_base_exception_t_vtable
	___cfaehm_base_exception_t_vtable_instance;


void __cfaehm_cancel_stack(exception_t * except) __attribute__((noreturn));

// Used in throw statement translation.
void __cfaehm_throw_terminate(exception_t * except) __attribute__((noreturn));
void __cfaehm_rethrow_terminate() __attribute__((noreturn));
void __cfaehm_throw_resume(exception_t * except);

// Function catches termination exceptions.
void __cfaehm_try_terminate(
    void (*try_block)(),
    void (*catch_block)(int index, exception_t * except),
    int (*match_block)(exception_t * except));

// Clean-up the exception in catch blocks.
void __cfaehm_cleanup_terminate(void * except);

// Data structure creates a list of resume handlers.
struct __cfaehm_try_resume_node {
    struct __cfaehm_try_resume_node * next;
    _Bool (*handler)(exception_t * except);
};

// These act as constructor and destructor for the resume node.
void __cfaehm_try_resume_setup(
    struct __cfaehm_try_resume_node * node,
    _Bool (*handler)(exception_t * except));
void __cfaehm_try_resume_cleanup(
    struct __cfaehm_try_resume_node * node);

// Check for a standard way to call fake deconstructors.
struct __cfaehm_cleanup_hook {};

#ifdef __cforall
}
#endif
