
class Architecture:
	def __init__(self, cmd):
		if cmd:
			self.cross_compile = True
			self.target = cmd
		else:
			self.cross_compile = False
			self.target = 'x64'

	def toString(self):
		return self.target

def init( options ):
	global arch
	global dry_run
	global generating
	global make
	global debug
	global debugFlag

	arch       = Architecture(options.arch)
	dry_run    = options.dry_run
	generating = options.regenerate_expected
	make       = './make_command_not_initialized'
	debug	     = "debug" if options.debug else "no debug"
	debugFlag  = """DEBUG_FLAGS="%s" """ % ("-debug" if debug else "-nodebug")

def updateMakeCmd(force, jobs):
	global make

	make = "make" if force else ("make -j%i" % jobs)