set terminal pdf color enhanced size 6.0in,3.0in font "Times,17"
#set terminal postscript portrait enhanced size 7.5, 10. color solid 9.5;
#set terminal wxt size 950,1250

INDIR="build"
OUTDIR="build"

set macros
set output OUTDIR."/plot-string-peq-cppemu.pdf"
#set pointsize 2.0
set grid
set key top left
set xtics (1,2,5,10,20,50,100,200,500)
set logscale x
#set logscale y
set yrange [0:115]
set xlabel "String Length being appended (mean, geo. dist.), log scale" offset 2,0
set ylabel "Time per append (ns, mean)"
set linetype 2 dashtype 2
set linetype 4 dashtype 2
plot INDIR."/plot-string-peq-cppemu.dat" \
	   i 0 using 1:2 title columnheader(1) with linespoints lt rgb "red"	pt  2  ps 1 lw 1, \
	'' i 1 using 1:2 title columnheader(1) with linespoints lt rgb "red"	pt  3  ps 1 lw 1, \
	'' i 2 using 1:2 title columnheader(1) with linespoints lt rgb "blue"	pt  6  ps 1 lw 1, \
	'' i 3  using 1:2 title columnheader(1) with linespoints lt rgb "blue"	pt  8  ps 1 lw 1
