//
// Cforall Version 1.0.0 Copyright (C) 2016 University of Waterloo
//
// The contents of this file are covered under the licence agreement in the
// file "LICENCE" distributed with Cforall.
//
// builtins.c --
//
// Author           : Peter A. Buhr
// Created On       : Fri Jul 21 16:21:03 2017
// Last Modified By : Andrew Beach
// Last Modified On : Tus Jul 25 15:33:00 2017
// Update Count     : 14
//

// exception implementation

typedef unsigned long long __cfaabi_exception_type_t;

#include "../libcfa/virtual.h"
#include "../libcfa/exception.h"

// exponentiation operator implementation

extern "C" {
	float powf( float x, float y );
	double pow( double x, double y );
	long double powl( long double x, long double y );
	float _Complex cpowf( float _Complex x, _Complex float z );
	double _Complex cpow( double _Complex x, _Complex double z );
	long double _Complex cpowl( long double _Complex x, _Complex long double z );
} // extern "C"

static inline float ?\?( float x, float y ) { return powf( x, y ); }
static inline double ?\?( double x, double y ) { return pow( x, y ); }
static inline long double ?\?( long double x, long double y ) { return powl( x, y ); }
static inline float _Complex ?\?( float _Complex x, _Complex float y ) { return cpowf(x, y ); }
static inline double _Complex ?\?( double _Complex x, _Complex double y ) { return cpow( x, y ); }
static inline long double _Complex ?\?( long double _Complex x, _Complex long double y ) { return cpowl( x, y ); }

static inline long int ?\?( long int ep, unsigned long int y ) { // disallow negative exponent
	if ( y == 0 ) return 1;								// base case
    if ( ep == 2 ) return ep << (y - 1);				// special case, positive shifting only
    typeof( ep ) op = 1;								// accumulate odd product
    for ( ; y > 1; y >>= 1 ) {							// squaring exponentiation, O(log2 y)
		if ( (y & 1) == 1 ) op *= ep;					// odd ?
		ep *= ep;
	} // for
    return ep * op;
} // ?\?

// FIX ME, cannot resolve the "T op = 1".

// static inline forall( otype T | { void ?{}( T * this, one_t ); T ?*?( T, T ); } )
// T ?\?( T ep, unsigned long int y ) {
//     if ( y == 0 ) return 1;
//     T op = 1;
//     for ( ; y > 1; y >>= 1 ) {							// squaring exponentiation, O(log2 y)
// 		if ( (y & 1) == 1 ) op = op * ep;				// odd ?
// 		ep = ep * ep;
//     } // for
//     return ep * op;
// } // ?\?

// unsigned computation may be faster and larger
static inline unsigned long int ?\?( unsigned long int ep, unsigned long int y ) { // disallow negative exponent
	if ( y == 0 ) return 1;								// base case
    if ( ep == 2 ) return ep << (y - 1);				// special case, positive shifting only
    typeof( ep ) op = 1;								// accumulate odd product
    for ( ; y > 1; y >>= 1 ) {							// squaring exponentiation, O(log2 y)
		if ( (y & 1) == 1 ) op *= ep;					// odd ?
		ep *= ep;
	} // for
    return ep * op;
} // ?\?

static inline double ?\?( long int x, signed long int y ) {	// allow negative exponent
    if ( y >=  0 ) return (double)(x \ (unsigned long int)y);
    else return 1.0 / x \ (unsigned int)(-y);
} // ?\?

// FIXME (x \ (unsigned long int)y) relies on X ?\?(T, unsigned long) a function that is neither 
// defined, nor passed as an assertion parameter. Without user-defined conversions, cannot specify 
// X as a type that casts to double, yet it doesn't make sense to write functions with that type 
// signature where X is double.

// static inline forall( otype T | { void ?{}( T & this, one_t ); T ?*?( T, T ); double ?/?( double, T ); } )
// double ?\?( T x, signed long int y ) {
//     if ( y >=  0 ) return (double)(x \ (unsigned long int)y);
//     else return 1.0 / x \ (unsigned long int)(-y);
// } // ?\?

static inline long int ?\=?( long int & x, unsigned long int y ) { x = x \ y; return x; }
static inline unsigned long int ?\=?( unsigned long int & x, unsigned long int y ) { x = x \ y; return x; }
static inline int ?\=?( int & x, unsigned long int y ) { x = x \ y; return x; }
static inline unsigned int ?\=?( unsigned int & x, unsigned long int y ) { x = x \ y; return x; }

// Local Variables: //
// mode: c //
// tab-width: 4 //
// End: //
