//
// Cforall Version 1.0.0 Copyright (C) 2015 University of Waterloo
//
// The contents of this file are covered under the licence agreement in the
// file "LICENCE" distributed with Cforall.
//
// Fwd.hpp -- Forward declarations of AST Types.
//
// Author           : Andrew Beach
// Created On       : Wed May  8 16:05:00 2019
// Last Modified By : Andrew Beach
// Last Modified On : Thr May  9 13:09:00 2019
// Update Count     : 0
//

#pragma once

#include "AST/Node.hpp"

namespace ast {

class ParseNode;

class Decl;
class DeclWithType;
class ObjectDecl;
class FunctionDecl;
class AggregateDecl;
class StructDecl;
class UnionDecl;
class EnumDecl;
class TraitDecl;
class NamedTypeDecl;
class TypeDecl;
class TypedefDecl;
class AsmDecl;
class StaticAssertDecl;

class Stmt;
class CompoundStmt;
class ExprStmt;
class AsmStmt;
class DirectiveStmt;
class IfStmt;
class WhileStmt;
class ForStmt;
class SwitchStmt;
class CaseStmt;
class BranchStmt;
class ReturnStmt;
class ThrowStmt;
class TryStmt;
class CatchStmt;
class FinallyStmt;
class WaitForStmt;
class WithStmt;
class DeclStmt;
class NullStmt;
class ImplicitCtorDtorStmt;

class Expr;
class ApplicationExpr;
class UntypedExpr;
class NameExpr;
class AddressExpr;
class LabelAddressExpr;
class CastExpr;
class KeywordCastExpr;
class VirtualCastExpr;
class MemberExpr;
class UntypedMemberExpr;
class VariableExpr;
class ConstantExpr;
class SizeofExpr;
class AlignofExpr;
class UntypedOffsetofExpr;
class OffsetofExpr;
class OffsetPackExpr;
class LogicalExpr;
class ConditionalExpr;
class CommaExpr;
class TypeExpr;
class AsmExpr;
class ImplicitCopyCtorExpr;
class ConstructorExpr;
class CompoundLiteralExpr;
class UntypedValofExpr;
class RangeExpr;
class UntypedTupleExpr;
class TupleExpr;
class TupleIndexExpr;
class TupleAssignExpr;
class StmtExpr;
class UniqueExpr;
class UntypedInitExpr;
class InitExpr;
class DeletedExpr;
class DefaultArgExpr;
class GenericExpr;

class Type;
class VoidType;
class BasicType;
class PointerType;
class ArrayType;
class ReferenceType;
class QualifiedType;
class FunctionType;
class ReferenceToType;
class StructInstType;
class UnionInstType;
class EnumInstType;
class TraitInstType;
class TypeInstType;
class TupleType;
class TypeofType;
class VarArgsType;
class ZeroType;
class OneType;
class GlobalScopeType;

class Designation;
class Init;
class SingleInit;
class ListInit;
class ConstructorInit;

class Constant;

class Label;

class Attribute;

class TypeSubstitution;

std::string toString( const Node * );

//=================================================================================================
/// This disgusting and giant piece of boiler-plate is here to solve a cyclic dependency
/// remove only if there is a better solution
/// The problem is that ast::ptr< ... > uses increment/decrement which won't work well with
/// forward declarations
inline void decrement( const class Node * node, Node::ref_type ref ) { node->decrement(ref); }
inline void increment( const class Node * node, Node::ref_type ref ) { node->increment(ref); }
inline void increment( const class ParseNode *, Node::ref_type );
inline void decrement( const class ParseNode *, Node::ref_type );
inline void increment( const class Decl *, Node::ref_type );
inline void decrement( const class Decl *, Node::ref_type );
inline void increment( const class DeclWithType *, Node::ref_type );
inline void decrement( const class DeclWithType *, Node::ref_type );
inline void increment( const class ObjectDecl *, Node::ref_type );
inline void decrement( const class ObjectDecl *, Node::ref_type );
inline void increment( const class FunctionDecl *, Node::ref_type );
inline void decrement( const class FunctionDecl *, Node::ref_type );
inline void increment( const class AggregateDecl *, Node::ref_type );
inline void decrement( const class AggregateDecl *, Node::ref_type );
inline void increment( const class StructDecl *, Node::ref_type );
inline void decrement( const class StructDecl *, Node::ref_type );
inline void increment( const class UnionDecl *, Node::ref_type );
inline void decrement( const class UnionDecl *, Node::ref_type );
inline void increment( const class EnumDecl *, Node::ref_type );
inline void decrement( const class EnumDecl *, Node::ref_type );
inline void increment( const class TraitDecl *, Node::ref_type );
inline void decrement( const class TraitDecl *, Node::ref_type );
inline void increment( const class NamedTypeDecl *, Node::ref_type );
inline void decrement( const class NamedTypeDecl *, Node::ref_type );
inline void increment( const class TypeDecl *, Node::ref_type );
inline void decrement( const class TypeDecl *, Node::ref_type );
inline void increment( const class TypedefDecl *, Node::ref_type );
inline void decrement( const class TypedefDecl *, Node::ref_type );
inline void increment( const class AsmDecl *, Node::ref_type );
inline void decrement( const class AsmDecl *, Node::ref_type );
inline void increment( const class StaticAssertDecl *, Node::ref_type );
inline void decrement( const class StaticAssertDecl *, Node::ref_type );
inline void increment( const class Stmt *, Node::ref_type );
inline void decrement( const class Stmt *, Node::ref_type );
inline void increment( const class CompoundStmt *, Node::ref_type );
inline void decrement( const class CompoundStmt *, Node::ref_type );
inline void increment( const class ExprStmt *, Node::ref_type );
inline void decrement( const class ExprStmt *, Node::ref_type );
inline void increment( const class AsmStmt *, Node::ref_type );
inline void decrement( const class AsmStmt *, Node::ref_type );
inline void increment( const class DirectiveStmt *, Node::ref_type );
inline void decrement( const class DirectiveStmt *, Node::ref_type );
inline void increment( const class IfStmt *, Node::ref_type );
inline void decrement( const class IfStmt *, Node::ref_type );
inline void increment( const class WhileStmt *, Node::ref_type );
inline void decrement( const class WhileStmt *, Node::ref_type );
inline void increment( const class ForStmt *, Node::ref_type );
inline void decrement( const class ForStmt *, Node::ref_type );
inline void increment( const class SwitchStmt *, Node::ref_type );
inline void decrement( const class SwitchStmt *, Node::ref_type );
inline void increment( const class CaseStmt *, Node::ref_type );
inline void decrement( const class CaseStmt *, Node::ref_type );
inline void increment( const class BranchStmt *, Node::ref_type );
inline void decrement( const class BranchStmt *, Node::ref_type );
inline void increment( const class ReturnStmt *, Node::ref_type );
inline void decrement( const class ReturnStmt *, Node::ref_type );
inline void increment( const class ThrowStmt *, Node::ref_type );
inline void decrement( const class ThrowStmt *, Node::ref_type );
inline void increment( const class TryStmt *, Node::ref_type );
inline void decrement( const class TryStmt *, Node::ref_type );
inline void increment( const class CatchStmt *, Node::ref_type );
inline void decrement( const class CatchStmt *, Node::ref_type );
inline void increment( const class FinallyStmt *, Node::ref_type );
inline void decrement( const class FinallyStmt *, Node::ref_type );
inline void increment( const class WaitForStmt *, Node::ref_type );
inline void decrement( const class WaitForStmt *, Node::ref_type );
inline void increment( const class WithStmt *, Node::ref_type );
inline void decrement( const class WithStmt *, Node::ref_type );
inline void increment( const class DeclStmt *, Node::ref_type );
inline void decrement( const class DeclStmt *, Node::ref_type );
inline void increment( const class NullStmt *, Node::ref_type );
inline void decrement( const class NullStmt *, Node::ref_type );
inline void increment( const class ImplicitCtorDtorStmt *, Node::ref_type );
inline void decrement( const class ImplicitCtorDtorStmt *, Node::ref_type );
inline void increment( const class Expr *, Node::ref_type );
inline void decrement( const class Expr *, Node::ref_type );
inline void increment( const class ApplicationExpr *, Node::ref_type );
inline void decrement( const class ApplicationExpr *, Node::ref_type );
inline void increment( const class UntypedExpr *, Node::ref_type );
inline void decrement( const class UntypedExpr *, Node::ref_type );
inline void increment( const class NameExpr *, Node::ref_type );
inline void decrement( const class NameExpr *, Node::ref_type );
inline void increment( const class AddressExpr *, Node::ref_type );
inline void decrement( const class AddressExpr *, Node::ref_type );
inline void increment( const class LabelAddressExpr *, Node::ref_type );
inline void decrement( const class LabelAddressExpr *, Node::ref_type );
inline void increment( const class CastExpr *, Node::ref_type );
inline void decrement( const class CastExpr *, Node::ref_type );
inline void increment( const class KeywordCastExpr *, Node::ref_type );
inline void decrement( const class KeywordCastExpr *, Node::ref_type );
inline void increment( const class VirtualCastExpr *, Node::ref_type );
inline void decrement( const class VirtualCastExpr *, Node::ref_type );
inline void increment( const class MemberExpr *, Node::ref_type );
inline void decrement( const class MemberExpr *, Node::ref_type );
inline void increment( const class UntypedMemberExpr *, Node::ref_type );
inline void decrement( const class UntypedMemberExpr *, Node::ref_type );
inline void increment( const class VariableExpr *, Node::ref_type );
inline void decrement( const class VariableExpr *, Node::ref_type );
inline void increment( const class ConstantExpr *, Node::ref_type );
inline void decrement( const class ConstantExpr *, Node::ref_type );
inline void increment( const class SizeofExpr *, Node::ref_type );
inline void decrement( const class SizeofExpr *, Node::ref_type );
inline void increment( const class AlignofExpr *, Node::ref_type );
inline void decrement( const class AlignofExpr *, Node::ref_type );
inline void increment( const class UntypedOffsetofExpr *, Node::ref_type );
inline void decrement( const class UntypedOffsetofExpr *, Node::ref_type );
inline void increment( const class OffsetofExpr *, Node::ref_type );
inline void decrement( const class OffsetofExpr *, Node::ref_type );
inline void increment( const class OffsetPackExpr *, Node::ref_type );
inline void decrement( const class OffsetPackExpr *, Node::ref_type );
inline void increment( const class LogicalExpr *, Node::ref_type );
inline void decrement( const class LogicalExpr *, Node::ref_type );
inline void increment( const class ConditionalExpr *, Node::ref_type );
inline void decrement( const class ConditionalExpr *, Node::ref_type );
inline void increment( const class CommaExpr *, Node::ref_type );
inline void decrement( const class CommaExpr *, Node::ref_type );
inline void increment( const class TypeExpr *, Node::ref_type );
inline void decrement( const class TypeExpr *, Node::ref_type );
inline void increment( const class AsmExpr *, Node::ref_type );
inline void decrement( const class AsmExpr *, Node::ref_type );
inline void increment( const class ImplicitCopyCtorExpr *, Node::ref_type );
inline void decrement( const class ImplicitCopyCtorExpr *, Node::ref_type );
inline void increment( const class ConstructorExpr *, Node::ref_type );
inline void decrement( const class ConstructorExpr *, Node::ref_type );
inline void increment( const class CompoundLiteralExpr *, Node::ref_type );
inline void decrement( const class CompoundLiteralExpr *, Node::ref_type );
inline void increment( const class UntypedValofExpr *, Node::ref_type );
inline void decrement( const class UntypedValofExpr *, Node::ref_type );
inline void increment( const class RangeExpr *, Node::ref_type );
inline void decrement( const class RangeExpr *, Node::ref_type );
inline void increment( const class UntypedTupleExpr *, Node::ref_type );
inline void decrement( const class UntypedTupleExpr *, Node::ref_type );
inline void increment( const class TupleExpr *, Node::ref_type );
inline void decrement( const class TupleExpr *, Node::ref_type );
inline void increment( const class TupleIndexExpr *, Node::ref_type );
inline void decrement( const class TupleIndexExpr *, Node::ref_type );
inline void increment( const class TupleAssignExpr *, Node::ref_type );
inline void decrement( const class TupleAssignExpr *, Node::ref_type );
inline void increment( const class StmtExpr *, Node::ref_type );
inline void decrement( const class StmtExpr *, Node::ref_type );
inline void increment( const class UniqueExpr *, Node::ref_type );
inline void decrement( const class UniqueExpr *, Node::ref_type );
inline void increment( const class UntypedInitExpr *, Node::ref_type );
inline void decrement( const class UntypedInitExpr *, Node::ref_type );
inline void increment( const class InitExpr *, Node::ref_type );
inline void decrement( const class InitExpr *, Node::ref_type );
inline void increment( const class DeletedExpr *, Node::ref_type );
inline void decrement( const class DeletedExpr *, Node::ref_type );
inline void increment( const class DefaultArgExpr *, Node::ref_type );
inline void decrement( const class DefaultArgExpr *, Node::ref_type );
inline void increment( const class GenericExpr *, Node::ref_type );
inline void decrement( const class GenericExpr *, Node::ref_type );
inline void increment( const class Type *, Node::ref_type );
inline void decrement( const class Type *, Node::ref_type );
inline void increment( const class VoidType *, Node::ref_type );
inline void decrement( const class VoidType *, Node::ref_type );
inline void increment( const class BasicType *, Node::ref_type );
inline void decrement( const class BasicType *, Node::ref_type );
inline void increment( const class PointerType *, Node::ref_type );
inline void decrement( const class PointerType *, Node::ref_type );
inline void increment( const class ArrayType *, Node::ref_type );
inline void decrement( const class ArrayType *, Node::ref_type );
inline void increment( const class ReferenceType *, Node::ref_type );
inline void decrement( const class ReferenceType *, Node::ref_type );
inline void increment( const class QualifiedType *, Node::ref_type );
inline void decrement( const class QualifiedType *, Node::ref_type );
inline void increment( const class FunctionType *, Node::ref_type );
inline void decrement( const class FunctionType *, Node::ref_type );
inline void increment( const class ReferenceToType *, Node::ref_type );
inline void decrement( const class ReferenceToType *, Node::ref_type );
inline void increment( const class StructInstType *, Node::ref_type );
inline void decrement( const class StructInstType *, Node::ref_type );
inline void increment( const class UnionInstType *, Node::ref_type );
inline void decrement( const class UnionInstType *, Node::ref_type );
inline void increment( const class EnumInstType *, Node::ref_type );
inline void decrement( const class EnumInstType *, Node::ref_type );
inline void increment( const class TraitInstType *, Node::ref_type );
inline void decrement( const class TraitInstType *, Node::ref_type );
inline void increment( const class TypeInstType *, Node::ref_type );
inline void decrement( const class TypeInstType *, Node::ref_type );
inline void increment( const class TupleType *, Node::ref_type );
inline void decrement( const class TupleType *, Node::ref_type );
inline void increment( const class TypeofType *, Node::ref_type );
inline void decrement( const class TypeofType *, Node::ref_type );
inline void increment( const class VarArgsType *, Node::ref_type );
inline void decrement( const class VarArgsType *, Node::ref_type );
inline void increment( const class ZeroType *, Node::ref_type );
inline void decrement( const class ZeroType *, Node::ref_type );
inline void increment( const class OneType *, Node::ref_type );
inline void decrement( const class OneType *, Node::ref_type );
inline void increment( const class GlobalScopeType *, Node::ref_type );
inline void decrement( const class GlobalScopeType *, Node::ref_type );
inline void increment( const class Designation *, Node::ref_type );
inline void decrement( const class Designation *, Node::ref_type );
inline void increment( const class Init *, Node::ref_type );
inline void decrement( const class Init *, Node::ref_type );
inline void increment( const class SingleInit *, Node::ref_type );
inline void decrement( const class SingleInit *, Node::ref_type );
inline void increment( const class ListInit *, Node::ref_type );
inline void decrement( const class ListInit *, Node::ref_type );
inline void increment( const class ConstructorInit *, Node::ref_type );
inline void decrement( const class ConstructorInit *, Node::ref_type );
inline void increment( const class Constant *, Node::ref_type );
inline void decrement( const class Constant *, Node::ref_type );
inline void increment( const class Attribute *, Node::ref_type );
inline void decrement( const class Attribute *, Node::ref_type );
inline void increment( const class TypeSubstitution *, Node::ref_type );
inline void decrement( const class TypeSubstitution *, Node::ref_type );

typedef unsigned int UniqueId;

}
