//
// Cforall Version 1.0.0 Copyright (C) 2015 University of Waterloo
//
// The contents of this file are covered under the licence agreement in the
// file "LICENCE" distributed with Cforall.
//
// BasicType.cc -- 
//
// Author           : Richard C. Bilson
// Created On       : Mon May 18 07:44:20 2015
// Last Modified By : Peter A. Buhr
// Last Modified On : Mon Sep 25 14:14:03 2017
// Update Count     : 11
//

#include <cassert>  // for assert
#include <list>     // for list
#include <ostream>  // for operator<<, ostream

#include "Type.h"   // for BasicType, Type, BasicType::Kind, BasicType::Kind...

class Attribute;

BasicType::BasicType( const Type::Qualifiers &tq, Kind bt, const std::list< Attribute * > & attributes ) : Type( tq, attributes ), kind( bt ) {}

void BasicType::print( std::ostream &os, int indent ) const {
	Type::print( os, indent );
	os << BasicType::typeNames[ kind ];
}

bool BasicType::isInteger() const {
	switch ( kind ) {
	  case Bool:
	  case Char:
	  case SignedChar:
	  case UnsignedChar:
	  case ShortSignedInt:
	  case ShortUnsignedInt:
	  case SignedInt:
	  case UnsignedInt:
	  case LongSignedInt:
	  case LongUnsignedInt:
	  case LongLongSignedInt:
	  case LongLongUnsignedInt:
	  case SignedInt128:
	  case UnsignedInt128:
		return true;
	  case Float:
	  case Double:
	  case LongDouble:
	  case FloatComplex:
	  case DoubleComplex:
	  case LongDoubleComplex:
	  case FloatImaginary:
	  case DoubleImaginary:
	  case LongDoubleImaginary:
		return false;
	  case NUMBER_OF_BASIC_TYPES:
		assert( false );
	} // switch
	assert( false );
	return false;
}


// Local Variables: //
// tab-width: 4 //
// mode: c++ //
// compile-command: "make install" //
// End: //
