//
// Cforall Version 1.0.0 Copyright (C) 2015 University of Waterloo
//
// The contents of this file are covered under the licence agreement in the
// file "LICENCE" distributed with Cforall.
//
// ForallSubstitutionTable.cpp --
//
// Author           : Aaron B. Moss
// Created On       : Thu Jun 27 14:00:00 2019
// Last Modified By : Aaron B. Moss
// Last Modified On : Thu Jun 27 14:00:00 2019
// Update Count     : 1
//

#include "ForallSubstitutionTable.hpp"

#include <cassert>
#include <vector>

#include "Copy.hpp"                // for shallowCopy
#include "Decl.hpp"
#include "Node.hpp"
#include "Type.hpp"
#include "Visitor.hpp"

namespace ast {

std::vector< ptr< TypeDecl > > ForallSubstitutionTable::clone(
	const std::vector< ptr< TypeDecl > > & forall, Visitor & v
) {
	std::vector< ptr< TypeDecl > > new_forall;
	new_forall.reserve( forall.size() );

	for ( const ast::TypeDecl * d : forall ) {
		// create cloned type decl and insert into substitution map before further mutation
		auto new_d = shallowCopy( d );
		decls.insert( d, new_d );
		// perform other mutations and add to output
		auto newer_d = v.visit( new_d );
		assert( new_d == newer_d && "Newly cloned TypeDecl must retain identity" );
		new_forall.emplace_back( new_d );
	}

	return new_forall;
}

}

// Local Variables: //
// tab-width: 4 //
// mode: c++ //
// compile-command: "make install" //
// End: //
