//
// Cforall Version 1.0.0 Copyright (C) 2015 University of Waterloo
//
// The contents of this file are covered under the licence agreement in the
// file "LICENCE" distributed with Cforall.
//
// VarExprReplacer.h --
//
// Author           : Rob Schluntz
// Created On       : Wed Jan 13 16:29:30 2016
// Last Modified By : Rob Schluntz
// Last Modified On : Fri May 13 11:27:52 2016
// Update Count     : 5
//

#ifndef VAR_EXPR_REPLACER_H
#define VAR_EXPR_REPLACER_H

#include <map>

#include "SynTree/SynTree.h"

/// Visitor that replaces the declarations that VariableExprs refer to, according to the supplied mapping
class VarExprReplacer : public Visitor {
public:
	typedef std::map< DeclarationWithType *, DeclarationWithType * > DeclMap;
private:
	const DeclMap & declMap;
public:
	VarExprReplacer( const DeclMap & declMap );

	// replace variable with new node from decl map
	virtual void visit( VariableExpr * varExpr );
};

#endif // VAR_EXPR_REPLACER_H

// Local Variables: //
// tab-width: 4 //
// mode: c++ //
// compile-command: "make install" //
// End: //
