//
// Cforall Version 1.0.0 Copyright (C) 2015 University of Waterloo
//
// The contents of this file are covered under the licence agreement in the
// file "LICENCE" distributed with Cforall.
//
// VarExprReplacer.h --
//
// Author           : Rob Schluntz
// Created On       : Wed Jan 13 16:29:30 2016
// Last Modified By : Rob Schluntz
// Last Modified On : Fri May 13 11:27:52 2016
// Update Count     : 5
//

#include "Expression.h"
#include "VarExprReplacer.h"

VarExprReplacer::VarExprReplacer( const DeclMap & declMap ) : declMap( declMap ) {}

// replace variable with new node from decl map
void VarExprReplacer::visit( VariableExpr * varExpr ) {
  if ( declMap.count( varExpr->get_var() ) ) {
    varExpr->set_var( declMap.at( varExpr->get_var() ) );
  }
}
